/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MO_MESH_
#define  _MO_MESH_

#include <MeshVizXLM/mapping/nodes/MoActionNode.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>

class MiMesh;
class MoMeshRepresentation;

/**
 * @DTEXT Property node that defines a mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Attributes
 * 
 * @DESCRIPTION
 * This node stores the object implementing a mesh interface in the scene graph.
 * Several types of meshes can be stored in the scene graph (see #setMesh method for more details)
 * All mesh representation nodes derived from MoMeshRepresentation use this mesh.
 * The mesh can be set explicitly using the #setMesh method or implicitly using the
 * connectFrom() method to use the result of a previous representation. 
 *
 * @note Each time the current mesh geometry and/or topology are updated (see MiTopology::getTimeStamp()
 * and MiGeometry::getTimeStamp()), touch() must be called to mark the node as modified.
 *
 * @FILE_FORMAT_DEFAULT
 *    Mesh {
 *    @TABLE_FILE_FORMAT
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *   SoWriteAction @BR
 *       The output of an SoWriteAction on this class is empty.
 *
 * @SEE_ALSO
 *   MiMesh
 * 
 */
class MESHVIZXLM_DMAP_API MoMesh : public MoActionNode {

  SO_NODE_HEADER(MoMesh) ;
  
 public:

  /**
   * Constructor.
   */
  MoMesh() ;

  /**
  * Sets the mesh interface to be stored in the scene graph. The node will automatically be marked as
  * modified by calling touch() and all associated representations will be cleared, resutling in a full
  * rendering of the corresponding scenegraph.
  *
  * @note When the current mesh geometry and topology have simply been updated (see MiTopology::getTimeStamp()
  * and MiGeometry::getTimeStamp()), it is then better to just call touch() instead. 
  *
  * If the mesh must come from the output of another representation, use the connectFrom() 
  * method instead of setMesh().
  *
  * Supported volume meshes are MiVolumeMeshUnstructured, MiVolumeMeshHexahedronIjk,
  * MiVolumeMeshVertexHexahedronIjk, MiVolumeMeshRegular, MiVolumeMeshRectilinear and MiVolumeMeshCurvilinear.
  * Supported surface meshes are MiSurfaceMeshUnstructured, MiSurfaceMeshRegular, MiSurfaceMeshRectilinear and 
  * MiSurfaceMeshCurvilinear.
  *
  * Supported line meshes are MiLineMeshUnstructured, MiLineMeshRegular and MiLineMeshCurvilinear.
  *
  * The given mesh is checked to ensure that a supported type is provided. If not, NULL is set instead.
  */
  virtual void setMesh(const MiMesh* mesh);

  /**
  * Resets the mesh interface to NULL (as if setMesh was given a NULL pointer).
  * Sets the node as modified by calling touch().
  */
  virtual void reset();

  /**
   * Sets the mesh interface by giving the mesh representation node from which the input mesh will be created.
   * When calling this method, the mesh is set internally each time the inputRep representation changes during traversal.
   * This is useful when a representation must be made on top of another one such as isolines on top of an isosurface.
   *
   */
  virtual void connectFrom(MoMeshRepresentation* inputRep);
  
  /**
   * Gets the mesh interface and the type of mesh stored
   */
  virtual const MiMesh* getMesh(MeshType &meshType);

 /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

protected:
  virtual ~MoMesh() ;

private:
  const MiMesh* m_mesh;
  MeshType m_meshType;
  MoMeshRepresentation* m_connectFrom;
  size_t m_timeStamp;
} ; 

#endif /* _MO_MESHP_  */

