/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHBASEREPRESENTATION_
#define  _MO_MESHBASEREPRESENTATION_

#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/misc/SoChildList.h>
#include <MeshVizXLM/mapping/nodes/MoActionNode.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MxNodeSensor;

/**
 * @DTEXT  Abstract base class for all MeshViz XLM representation nodes.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *    Abstract base class for all MeshViz XLM representation nodes.
 *
 * @ACTION_BEHAVIOR
 *    SoWriteAction @BR
 *        The output of an SoWriteAction on any mesh representation uses the output of the write action of all
 *        Open Inventor standard shapes used internally by MeshViz XLM to render a mesh. There is no alternative rep
 *        option that allows writing only the list of standard shapes used.
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshBaseRepresentation : public MoActionNode {

  SO_NODE_HEADER(MoMeshBaseRepresentation) ;

 public:
   virtual SbBool affectsState() const;

 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

  virtual void fieldHasChanged(SoField* field);

  virtual bool isSynchronizingContentOnly() { return TRUE; }

 SoEXTENDER public:
  virtual void write(SoWriteAction *action);
  virtual void doAction(SoAction *action);

 protected:
  MoMeshBaseRepresentation() ;
  virtual ~MoMeshBaseRepresentation() ;  

  // The separator containing the generated scene graph
  SoSeparator *m_group;

  virtual SoChildList *getChildren() const { return m_childList; }

  virtual void clear();

  // indicates if any fields has been modified (linked to a node sensor)
  bool isModified() const;

private:
  // Implements a hidden list of children
  SoChildList *m_childList;

  // Internal mechanism used to detect that the node has changed.
  bool m_subSceneDirty;

};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHBASEREPRESENTATION_ */



