/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (October 2009)
**=======================================================================*/
#ifndef  _MO_MESHCLIPLINE_
#define  _MO_MESHCLIPLINE_

#include <MeshVizXLM/mapping/nodes/MoMeshLineRepresentation.h>

#include <Inventor/fields/SoSFPlane.h>
#include <Inventor/fields/SoMFVec3f.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiClipLineExtractUnstructured;
class MiClipLineExtractIj;

/**
 * @DTEXT  Rendering node that displays a clip line of a surface mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  A clip line is an unstructured line mesh defined by the intersection of several arbitrary planes
 *  with a surface mesh.
 *  Two types of clip line are possible:
 *  - a clip line is the projection along a #direction of an input #polyline onto a 3D surface mesh.
 *    This type of clip line requires at least 2 points in the #polyline.
 *    The projected polyline follows the shape of the 3D surface.@BR
 *    The ClipLine example highlights this first use case.
 *
 *    <CENTER>@IMAGE clipline.png "Clip line"</CENTER>
 *
 *  - a clip line is the intersection of a plane and a 3D surface when the field #polyline contains
 *    one single point. The plane is defined by the point of the #polyline and its normal vector defined
 *    by #direction. If the 3D surface is flat, the output clip line follows a straight line.
 *    If the 3D surface corresponds to the external skin of a volume, the clip line is a closed contour.@BR
 *    The ClipLineOnSkin example highlights this second use case.
 *
 *    <CENTER>@IMAGE cliplineonskin.png "Clip line on skin"</CENTER>
 *
 *  The line can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSet node). To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshClipLine {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR plane                      @TD 0,0,1,0
 *       @TR polyline                   @TD empty
 *       @TR direction                  @TD 1,0,0
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, @BR
 *  MiClipLineExtractIj,
 *  MiClipLineExtractUnstructured,
 *  MoLineDetail
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshClipLine : public MoMeshLineRepresentation {

  SO_NODE_HEADER(MoMeshClipLine) ;

 public:

  /**
   * Constructor.
   */
  MoMeshClipLine() ;

  /**
   * Position of the plane slice. Z=0 plane by default.
   */
  SoDEPRECATED_FIELD(2023.1, "Use polyline and direction fields instead to define a plane.")
  SoSFPlane  plane;

  /**
  * Set of points defining a polyline to be projected on the 3D surface mesh.
  * If this field contains a single point P, an intersection of the plane (P, #direction)
  * is extracted and rendered.
  * This field is empty by default.
  *
  * @FIELD_SINCE_OIV 2023.1
  */
  SoMFVec3f polyline;

  /**
  * Direction of the projection or normal to the plane if #polyline contains a single point.
  * This field is set to the x-axis direction by default.
  *
  * @FIELD_SINCE_OIV 2023.1
  */
  SoSFVec3f direction;

  //@{
  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action traversal has occurred.
  */
  const MiClipLineExtractUnstructured*     getUnstructuredExtractor();
  const MiClipLineExtractIj*               getIjExtractor();
  //@}

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHCLIPLINE_ */



