/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Mar 2012)
**=======================================================================*/
#ifndef  _MoMeshClipPoint_H
#define  _MoMeshClipPoint_H

#include <MeshVizXLM/mapping/nodes/MoMeshRepresentation.h>

#include <Inventor/fields/SoSFPlane.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiClipPointExtract;

class MdMeshRepresentation;
class MdPointMesh;

/** 
 * @DTEXT  Rendering node that displays clip points of a line mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  Clip points are represented as an unstructured point mesh defined by the intersection
 *  of an arbitrary plane and a line mesh. 
 *  The plane (an SbPlane) is defined by a direction vector and a distance from the origin.
 *
 *  The points can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshClipPoint {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR plane                      @TD 0,0,1,0
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, @BR
 *  MiClipPointExtract
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshClipPoint : public MoMeshRepresentation {

  SO_NODE_HEADER(MoMeshClipPoint) ;

 public:

  /**
   * Constructor.
   */
  MoMeshClipPoint() ;

  /**
   * Position of the plane slice. Z=0 plane by default.
   */
  SoSFPlane  plane;

  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action traversal has occurred.
  */
  const MiClipPointExtract*     getExtractor() const;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
  static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

 private:
  virtual ~MoMeshClipPoint() ;  

  virtual void clear();
  
  template <MeshType _meshType> friend class MdMeshClipPoint;

  MdPointMesh*          m_pointMesh;

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MoMeshClipPoint_H */



