/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHELEVATEDPLANESLICE_
#define  _MO_MESHELEVATEDPLANESLICE_

#include <MeshVizXLM/MbVec3.h>

#include <MeshVizXLM/mapping/nodes/MoMeshPlaneSlice.h>

#include <Inventor/fields/SoSFPlane.h>
#include <Inventor/fields/SoSFDouble.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

/**
 * @DTEXT  Rendering node that displays an elevated plane slice of a volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  An elevated plane slice is based on an unstructured surface mesh defined by the intersection of 
 *  an arbitrary plane with a volume mesh. This surface is extruded with a height depending on
 *  the data extracted from the plane using the elevation scalar set, and a scale factor.
 *  The plane (an SbPlane) is defined by a direction vector and a distance from the origin.
 *
 *  The slice can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshElevatedPlaneSlice {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR elevationScalarSetId       @TD 0
 *       @TR scaleFactor                @TD 1.0
 *       @TR parallel                   @TD TRUE
 *       @TR plane                      @TD 0,0,1,0
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, MoFaceDetail, @BR
 *  MiPlaneSliceExtractIjk,
 *  MiPlaneSliceExtractUnstructured,
 *  MiPlaneSliceExtractHexahedronIjk
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshElevatedPlaneSlice : public MoMeshPlaneSlice {

  SO_NODE_HEADER( MoMeshElevatedPlaneSlice ) ;

 public:

  /**
   * Constructor.
   */
  MoMeshElevatedPlaneSlice() ;

  /**
   * The scaleFactor can be set to control the height of extruded cells.
   * By default, this value is set to 1.
   */
  SoSFDouble scaleFactor;

  /**
   * The scalar set to be used to map elevation onto the representation. @BR
   * During traversal of the scene graph, scalar set nodes are accumulated in a list of scalar sets.
   * elevationScalarSetId is an index into this list.
   * Default value is 0 which means that the first scalar set stored in the scene graph is used.
   * Setting this value to -1 enables the elevation values to be the same as used for color mapping.
   * Setting this value to another id enables the elevation values to be different than the ones used
   * for color mapping.
   */
  SoSFInt32 elevationScalarSetId;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract( SoAction *action );

 protected:
  virtual ~MoMeshElevatedPlaneSlice() ;  

  template<typename _MeshInterface, typename _Extractor, typename _ScalarSet, typename _MoScalarSet, typename _CellFilter>
  void doExtract( SoState * state, const _MeshInterface* mesh, _Extractor** extractor );

  template<typename _Extractor, typename _ScalarSet, typename _MoScalarSet, typename _CellFilter>
  void extract( SoState * state, _Extractor* extractor, const _CellFilter *cellFilter );

  void computePlane(MbVec3d& normal, double& distance);

  // Extractors used internally
  MiPlaneSliceExtractUnstructured*    m_planeSliceExtractU;
  MiPlaneSliceExtractHexahedronIjk* m_planeSliceExtractUIjk;
  MiPlaneSliceExtractIjk*             m_planeSliceExtractIjk;
} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHELEVATEDPLANESLICE_ */



