/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHFENCESLICE_
#define  _MO_MESHFENCESLICE_

#include <Inventor/fields/SoMFVec3f.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurfaceRepresentation.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiFenceSliceExtractUnstructured;
class MiFenceSliceExtractHexahedronIjk;
class MiFenceSliceExtractIjk;

/**
 * @DTEXT  Rendering node that displays a fence slice within a volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  A fence slice is an unstructured surface mesh defined by the intersection of several arbitrary planes (the fences)
 *  with a volume mesh. These fences are defined by a #polyline and a #direction. Each segment of the #polyline is
 *  extruded along the #direction to form a clipped plane slice. Thus, each fence goes through a segment of the polyline.
 *  Each plane slice is clipped by the extrusion of the 2 endpoints of each segment in the #direction.
 *
 *  The fence slice can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshFenceSlice {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR polyline                   @TD empty
 *       @TR direction                  @TD 1,0,0
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, MoScalarSet, @BR
 *  MiFenceSliceExtractIjk,
 *  MiFenceSliceExtractUnstructured,
 *  MiFenceSliceExtractHexahedronIjk, MoFaceDetail
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshFenceSlice : public MoMeshSurfaceRepresentation {

  SO_NODE_HEADER(MoMeshFenceSlice) ;

 public:

  /**
  * Constructor.
  */
  MoMeshFenceSlice() ;

  /**
  * Set of points defining the segments through which fence must pass. Each segment is extruded
  * along the #direction to form a strip of plane slices.
  * There is as much fence as segments.
  * This field is empty by default.
  */
  SoMFVec3f polyline;

  /**
  * Direction defining the fences.
  * This field is set to the x-axis direction by default.
  */
  SoSFVec3f direction;

  //@{
  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action has been called before.
  */
  const MiFenceSliceExtractUnstructured* getUnstructuredExtractor();
  const MiFenceSliceExtractHexahedronIjk* getHexahedronIjkExtractor();
  const MiFenceSliceExtractIjk* getIjkExtractor();
  //@}

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
  const MiFenceSliceExtractHexahedronIjk* getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHFENCESLICE_ */
