/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHGRIDPLANESLICE_
#define  _MO_MESHGRIDPLANESLICE_

#include <MeshVizXLM/mapping/nodes/MoMeshSurfaceRepresentation.h>

#include <Inventor/fields/SoSFPlane.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiGridPlaneSliceExtractUnstructured;
class MiGridPlaneSliceExtractHexahedronIjk;
class MiGridPlaneSliceExtractIjk;

/**
 * @DTEXT  Rendering node that displays a grid plane slice of a volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  A grid plane slice is similar to MoMeshPlaneSlice but the plane is treated as a 
 *  regular grid on which nodes are evaluated using the probing mechanism according
 *  to the specified step size (See the SEE ALSO Section for settings). 
 *  The plane (an SbPlane) is defined by a direction vector and a distance from the origin.
 *
 *  The slice can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshGridPlaneSlice {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR plane                      @TD 0,0,1,0
 *       @TR step                       @TD 1.0
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, MoFaceDetail, @BR
 *  MiGridPlaneSliceExtractIjk, 
 *  MiGridPlaneSliceExtractUnstructured, 
 *  MiGridPlaneSliceExtractHexahedronIjk. @BR
 *  MiPointProbeUnstructured, MiPointProbeHexahedronIjk,
 *  MiPointProbeIjk, MiPointProbeIj for probing settings.
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshGridPlaneSlice : public MoMeshSurfaceRepresentation {

  SO_NODE_HEADER(MoMeshGridPlaneSlice) ;

 public:

  /**
   * Constructor.
   */
  MoMeshGridPlaneSlice() ;

  /**
   * Position of the grid plane slice. Z=0 plane by default.
   */
  SoSFPlane  plane;

  /**
   * Step between nodes defining grid density. Default is 1.
   */
  SoSFFloat  step;

  //@{
  /** 
  * Get extractor for reuse outside this node. 
  * @note The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action has traversed the scene graph.
  */
  const MiGridPlaneSliceExtractUnstructured*     getUnstructuredExtractor();
  const MiGridPlaneSliceExtractHexahedronIjk*    getHexahedronIjkExtractor();
  const MiGridPlaneSliceExtractIjk*              getIjkExtractor();
  //@}

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
  const MiGridPlaneSliceExtractHexahedronIjk*    getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHGRIDPLANESLICE_ */



