/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHISOSURFACE_
#define  _MO_MESHISOSURFACE_

#include <MeshVizXLM/mapping/nodes/MoMeshSurfaceRepresentation.h>

#include <Inventor/fields/SoSFFloat.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiIsosurfExtractUnstructured;
class MiIsosurfExtractHexahedronIjk;
class MiIsosurfExtractIjk;

/**
 * @DTEXT  Rendering node that displays an isosurface of a volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  An isosurface is an unstructured surface mesh defined by all the points having the specified value 
 *  in the scalar data set. 
 *  The scalar set used to extract the isosurface is defined by the inherited isoScalarSetId field. 
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes).  If this scalar set is defined per cell, a new internal dataset 
 *  bound per node will be automatically computed and cached to perform the isosurface extraction.
 *
 *  The isosurface can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * \if_cpp
 * @note When applied to an unstructured volume mesh (see MiVolumeMeshUnstructred) with undefined 
 *       MiVolumeCell::getIsosurfTopology() such as polyhedral cells, an MoTessellator node 
 *       containing an instance of MiTessellator::getNewTessellatorPolyhedron() must be added to the
 *       scenegraph beforehand. Any other types derived from MiTessellator will be ignored.
 * \endif
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshIsosurface {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR isovalue                   @TD 0.0
 *       @TR isoScalarSetId             @TD 0
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, MoTessellator @BR
 *  MiIsosurfExtractIjk, 
 *  MiIsosurfExtractUnstructured,
 *  MiIsosurfExtractHexahedronIjk, MoFaceDetail
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshIsosurface : public MoMeshSurfaceRepresentation {

  SO_NODE_HEADER(MoMeshIsosurface) ;

 public:

  /**
   * Constructor.
   */
  MoMeshIsosurface() ;

  /**
   * Isovalue to display. Default is 0.0.
   */
  SoSFFloat  isovalue;

  /**
  * Field representing the scalar set node to be used to compute the iso value.
  * During traversal of the scene graph, scalar set nodes are accumulated in
  * a list of scalar sets.  isoScalarSetId is an index into this list. Default is 0.
  * If this scalar set is defined per cell, a new internal dataset 
  * defined per node will be automatically computed and cached to perform the isosurface extraction.
   */
  SoSFInt32  isoScalarSetId;

  //@{
  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action has traversed the scene graph. 
  * Use the method corresponding to the type of mesh stored in the scene graph. 
  * 
  */
  const MiIsosurfExtractUnstructured*    getUnstructuredExtractor();
  const MiIsosurfExtractHexahedronIjk* getHexahedronIjkExtractor();
  const MiIsosurfExtractIjk*             getIjkExtractor();
  //@}

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
  const MiIsosurfExtractHexahedronIjk* getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

#if SoDEPRECATED_BEGIN(8500)

  SoDEPRECATED_METHOD(8500,"Use getIjkExtractor() instead.")
  const MiIsosurfExtractIjk*             getRegularExtractor();

#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

protected:
  virtual ~MoMeshIsosurface() ;

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHISOSURFACE_ */



