/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Apr 2012)
**=======================================================================*/
#ifndef  _MoMeshLineRepresentation_H
#define  _MoMeshLineRepresentation_H

#include <MeshVizXLM/mapping/nodes/MoMeshRepresentation.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MdLineMesh;
class MdPointMesh;

/**
 * @DTEXT  Abstract base class for all MeshViz XLM line representation nodes containing an extractor.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *    Abstract base class for all MeshViz XLM line representation nodes containing an extractor.
 *
 *    The basic representations and the meshes they apply to are:
 *    - Line mesh
 *      - MoMeshLine
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshLineRepresentation : public MoMeshRepresentation {

  SO_NODE_HEADER(MoMeshLineRepresentation) ;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 protected:
  MoMeshLineRepresentation() ;
  virtual ~MoMeshLineRepresentation() ;  

  template<typename _ExtractorManagerT> friend class MdMeshLineRepresentation;

  virtual void clear();

  MdLineMesh*    m_line;
  MdPointMesh*   m_points;
};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MoMeshLineRepresentation_H */



