/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHOUTLINE_
#define  _MO_MESHOUTLINE_

#include <MeshVizXLM/mapping/nodes/MoMeshLineRepresentation.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MdMeshRepresentation;
class MiOutlineExtractUnstructured;
class MiOutlineExtractHexahedronIjk;
class MiOutlineExtractIjk;
class MiOutlineExtractIj;

/**
 * @DTEXT  Rendering node that displays the outline of a mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  The outline of a mesh is an unstructured line mesh made up of all the edges that belong to only 
 *  one cell. Internal edges of a mesh will not be displayed except when they are adjacent to dead cells.
 *
 *  The outline can be colored using a scalar set specified in the colorScalarSetId inherited field. 
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSet node). To disable coloring set this field to -1.
 *
 *  MoMaterial controls whether the outline is drawn with a single color or colored according to a scalar
 *  set (@I lineColoring@i field) and also specifies the single color to be used (@I lineColor@i field).
 *
 *  MoColorMapping subclasses specify the mapping from scalar values to color and opacity.
 *
 *  Note that MoDrawStyle affects the rendering of MoMeshOutline. If the @I displayEdges@i field is set
 *  to false, the mesh outline will be not be drawn.
 *
 *  The following image displays the outline of a hexahedron grid (see MiVolumeMeshHexahedronIjk).
 *  It hightlights the internal faults and the discontinuies on the external borders of the grid.
 *  The grey parts of the image correspond to a semi opaque skin of the grid (see MoMeshSkin).
 *  @TABLE_0B
 *      @TR @IMAGE MeshOutline1M.png "red mesh outline"
 *  @TABLE_END
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshOutline {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoMaterial, MoScalarSet, MoColorMapping, @BR
 *  MiOutlineExtractIj,
 *  MiOutlineExtractIjk,
 *  MiOutlineExtractUnstructured,
 *  MiOutlineExtractHexahedronIjk
 *
 */

class MESHVIZXLM_DMAP_API MoMeshOutline : public MoMeshLineRepresentation {

  SO_NODE_HEADER(MoMeshOutline) ;

 public:

  /**
   * Constructor.
   */
  MoMeshOutline() ;

  //@{
  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action traversal has been done yet.
  */
  const MiOutlineExtractUnstructured* getUnstructuredExtractor();
  const MiOutlineExtractHexahedronIjk* getHexahedronIjkExtractor();
  const MiOutlineExtractIjk* getIjkExtractor();
  const MiOutlineExtractIj*  getIjExtractor();
  //@}

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
  const MiOutlineExtractHexahedronIjk* getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHOUTLINE_ */



