/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHSLAB_
#define  _MO_MESHSLAB_

#include <Inventor/fields/SoSFUInt32.h>
#include <MeshVizXLM/mapping/nodes/MoMeshSurfaceRepresentation.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiSkinExtractUnstructured;
class MiSkinExtractHexahedronIjk;
class MiSkinExtractIjk;

class MdMeshRepresentation;

/**
 * @DTEXT  Rendering node that displays a slab of a structured volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  A slab of an IJK mesh is an unstructured surface mesh made of all visible faces from cells with the same index in the
 *  given dimension I, J or K. A thickness allows to add faces from the cells in the range [index, index + thickness].
 *
 *  The mesh can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 *  MoMeshLogicalSlice is a related representation, but extracts a surface along one face of each cell with the same
 *  index and so has no "thickness" along the slice axis. MoMeshInterpolatedLogicalSlice is similar, but instead of
 *  displaying the slice only on the face of the cells, it can interpolate a slice inside cells.
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshSlab {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR dimension                  @TD MiMesh::DIMENSION_I
 *       @TR index                      @TD 0
 *       @TR thickness                  @TD 1
 *    @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, @BR
 *  MoMeshLogicalSlice, MoMeshInterpolatedLogicalSlice,
 *  MiSkinExtractIjk,
 *  MiSkinExtractUnstructured,
 *  MiSkinExtractHexahedronIjk, MoFaceDetail
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshSlab : public MoMeshSurfaceRepresentation {

  SO_NODE_HEADER(MoMeshSlab) ;

 public:

  /**
   * Constructor.
   */
  MoMeshSlab() ;

  /**
  * The dimension along which the slab will be computed defined by the MiMesh::Dimension enum.
  * Default is MiMesh::DIMENSION_I.
  */
  SoSFEnum  dimension;
  /**
  * The index of the slab, 0 to N-1, where N is number of cells in the given dimension.
  * Default is 0.
  */
  SoSFUInt32  index;
  /**
  * Thickness of the slab in number of cells.
  * Default is 1 and defines a 1 cell thick slab. 
  * Value 0 defines an empty slab (nothing to display).
  * Values are automatically "clamped" at the mesh dimensions. 
  */
  SoSFUInt32  thickness;

  //@{
  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action has been called before.
  */
  const MiSkinExtractUnstructured* getUnstructuredExtractor();
  const MiSkinExtractHexahedronIjk* getHexahedronIjkExtractor();
  const MiSkinExtractIjk* getIjkExtractor();
  //@}

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
  const MiSkinExtractHexahedronIjk* getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHSKIN_ */



