/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHSPHERESLICE_
#define  _MO_MESHSPHERESLICE_

#include <MeshVizXLM/MbVec3.h>

#include <MeshVizXLM/mapping/nodes/MoMeshSurfaceRepresentation.h>
#include <MeshVizXLM/extractors/MiSphereSliceExtractUnstructuredIjk.h>

#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFVec3f.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiSphereSliceExtractUnstructured;
class MiSphereSliceExtractHexahedronIjk;
class MiSphereSliceExtractIjk;

/**
 * @DTEXT  Rendering node that displays a sphere slice of a volume mesh.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  A sphere slice is an unstructured surface mesh defined by the intersection of a 
 *  sphere with a volume mesh. The sphere is defined by its center position and radius.
 *
 *  The slice can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *  Rendering can be modified using various property nodes (see the SEE ALSO section).
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshSphereSlice {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR parallel                   @TD TRUE
 *       @TR center                     @TD 0,0,0
 *       @TR radius                     @TD 1.0
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial, @BR
 *  MiSphereSliceExtractIjk,
 *  MiSphereSliceExtractUnstructured,
 *  MiSphereSliceExtractHexahedronIjk, MoFaceDetail
 *
 */

class MESHVIZXLM_DMAP_API MoMeshSphereSlice : public MoMeshSurfaceRepresentation {

  SO_NODE_HEADER(MoMeshSphereSlice) ;

 public:

  /**
   * Constructor.
   */
  MoMeshSphereSlice() ;

  /**
   * Specifies the shpere's center. Default is 0,0,0.
   */
  SoSFVec3f center;

  /**
   * Specifies the sphere's radius. Value must be greater than 0.0. Default is 1.
   */
  SoSFFloat radius;

  //@{
  /** 
  * Get extractor for reuse outside this node. 
  * @note  The returned pointer may be null if a mesh has not been set in the scene graph 
  * or if no render action traversal has been done yet.
  */
  const MiSphereSliceExtractUnstructured*     getUnstructuredExtractor();
  const MiSphereSliceExtractHexahedronIjk*    getHexahedronIjkExtractor();
  const MiSphereSliceExtractIjk*              getIjkExtractor();
  //@}

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000,"Use getHexahedronIjkExtractor() instead.")
  const MiSphereSliceExtractHexahedronIjk*    getUnstructuredIjkExtractor();
#endif /** @DEPRECATED_END */

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction *action);

 protected:
  virtual ~MoMeshSphereSlice() ;  

} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHSPHERESLICE_ */



