/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MO_MESHVECTORS_
#define  _MO_MESHVECTORS_

#include <MeshVizXLM/MbVec3.h>

#include <MeshVizXLM/mapping/nodes/MoMeshRepresentation.h>
#include <MeshVizXLM/mapping/nodes/MoDataBinding.h>

#include <Inventor/fields/SoMFFloat.h>

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

class MiCellFilter;
class MiCellFilterI;
class MiMeshUnstructuredI;
class SoSwitch;
class MxIndexDataSetI;
class MiMeshUnstructuredI;

class MdVectors;
class MdLineVectors;
class MdFancyVectors;


/**
 * @DTEXT  Rendering node that displays a vector data set.
 * 
 * @ingroup MeshVizXLM_Mapping_Representation
 * 
 * @DESCRIPTION
 *  Each value of the vector data set is represented by a line plus an optional small arrow
 *  or a cylinder and an optional cone depending of the #thicknessFactor.
 *  The vectors are located at the cell centers for per cell data sets or at the node positions
 *  for per node data sets. 
 *  The vectorSetId field defines the index of the vector set to display. This is an index 
 *  into the list of vector sets existing in the traversal state (see the MoVec3Setxxx nodes).
 *
 *  The vectors can be colored using a scalar set defined in the colorScalarSetId inherited field.
 *  This is an index into the list of scalar sets existing in the traversal state
 *  (see the MoScalarSetxxx nodes). To disable coloring set this field to -1.
 *
 * @FILE_FORMAT_DEFAULT
 *    MeshVector {
 *    @TABLE_FILE_FORMAT
 *       @TR colorScalarSetId           @TD 0
 *       @TR vectorSetId                @TD 0
 *       @TR scaleFactor                @TD 1.0
 *       @TR shiftFactor                @TD 0.0
 *       @TR thicknessFactor            @TD 0.0
 *       @TR arrow                      @TD true
 *    @TABLE_END
 *    }
 * 
 */

class MESHVIZXLM_DMAP_API MoMeshVector : public MoMeshRepresentation {

  SO_NODE_HEADER(MoMeshVector) ;

 public:

  /**
   * Constructor.
   */
  MoMeshVector() ;

  /**
  * Specifies the vector set to display.
  * During traversal of the scene graph, vector sets are accumulated in a list of vector sets.
  * vectorSetId is an index in this list. Default is 0 meaning the first set in the list.
   */
  SoSFInt32  vectorSetId;

  /**
  * The scale factor to apply to the vector field to resize the representation.  
  * Default is 1.0. All values are accepted.
  * If scaleFactor is 0, the representation is empty.
  */
  SoSFFloat  scaleFactor;

  /**
  * The shift factor to apply to the representation of each vector.
  * Each vector is translated along its direction by the value of shiftFactor.
  *
  * Default is 0.0 (no shift). All values are accepted.
  *
  * The following images illustrate the effect of shiftFactor on the vector field representation,
  * with a vector set using a PER_NODE binding.
  *
  * @IMAGE VectorField_shiftFactor-0.png "shiftFactor = 0.0"
  * @IMAGE VectorField_shiftFactor-0.5.png "shiftFactor = -0.5"
  * @IMAGE VectorField_shiftFactor-1.png "shiftFactor = -1.0"
  *
  */
  SoSFFloat  shiftFactor;

  /**
  * The thickness factor to apply to the representation of each vector.
  * If the thickness factor is:
  *   - < 0, nothing is rendered.
  *   - = 0, each vector is displayed as a line (plus arrow if #arrow is true).
  *   - > 0, each vector is displayed as a cylinder (plus cone if #arrow is true).
  *
  * Factor values > 0 control both the radius of the cylinder and the radius of the cone.
  * For example, when the factor is 1 the radius of the cylinder is 5% of the average vector length
  * in the data set. Larger factors also proportionally increase the height of the cone
  * up to a maximum of half the vector length. When this limit is reached, larger values
  * of the factor have no effect unless the arrow is removed by setting #arrow to false.
  *
  * Default is 0.0.
  *
  * @FIELD_SINCE_OIV 10.1
  */
  SoSFFloat thicknessFactor;

  /**
  * Draw arrows on vectors. 
  * Default is true.
  */
  SoSFBool   arrow;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 SoEXTENDER public:
  virtual void doExtract(SoAction * action);

  // Does not create any new mesh so return NULL
  virtual const MiMesh* getExtractedMesh(MeshType& SO_UNUSED_PARAM(meshType)) { return NULL;}

 protected:
  virtual ~MoMeshVector() ;  

  void clear();
  
  void doExtract(SoState* state, const MiMeshUnstructuredI& realMesh);

  template < typename _adaptorT, typename _MeshIjT>
  void doExtractSurfaceIj(SoState* state, _MeshIjT& realMesh);

  template < typename _adaptorT, typename _MeshIjkT>
  void doExtractVolumeIjk(SoState* state, _MeshIjkT& realMesh, MoDataBinding::DataBinding* dataBinding = NULL);

  void buildVectors(SoState* state, const MiMeshUnstructuredI& uMesh, const MiVec3dSetI& vec3, 
                    const MiScalardSetI* colorSet, const MiCellFilterI* filter=NULL);

  bool haveValuesChanged(size_t topoTimeStamp, size_t geoTimeStamp, size_t vec3TimeStamp, 
                         SoState* state, const MiDataSet* colorSet, const MiCellFilter* filter=NULL);

  size_t m_topoTimeStamp;
  size_t m_geoTimeStamp;
  size_t m_vec3TimeStamp;
  size_t m_colorTimeStamp;
  size_t m_colorMapTimeStamp;
  size_t m_cellFilterTimeStamp;
  float m_scaleFactor;
  float m_shiftFactor;
  bool  m_arrow;

  SoSwitch* m_switchModel;
  MxIndexDataSetI* m_indexList;
  MdVectors* m_currentVectors;
  MdLineVectors* m_lineVectors;
  MdFancyVectors* m_fancyVectors;
} ;

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _MO_MESHVECTORS_ */



