/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Oct 2011)
**=======================================================================*/

#ifndef  _MoScalarSet_H
#define  _MoScalarSet_H

#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mapping/nodes/MoActionNode.h>
#include <MeshVizXLM/mesh/data/MiTypedDataSet.h>

/**
* @DTEXT Property node that stores any kind of scalar data set.
* 
* @ingroup MeshVizXLM_Mapping_Attributes
* 
* @DESCRIPTION
*    This node adds a reference to an object implementing the MiScalardSetI, MiScalardSetIj or 
*    MiScalarSetIjk interface to the list of scalar data sets in the traversal state.
*
*    Subsequent mesh representations will be able to use this data set for extraction,
*    coloring, etc. During traversal of the scene graph, MoScalarSet nodes are accumulated 
*    into a list so that an extraction can use multiple scalar sets during the same 
*    computation. For example, the first set (located at index 0 in the list) for computing 
*    an isosurface and the second set (located at index 1) for coloring it.
*
*    This node is recommended over MoScalarSetI, MoScalarSetIj or MoScalarSetIjk.
*
*    Note:
*    - Any time the associated MiScalardSet is updated, touch() must also be called
*      to mark the node as modified. In addition, MiScalardSet::getTimeStamp() must return a different 
*      value than before to actually trigger a new rendering.
*
*    - Scalar sets for unstructured meshes (MiScalardSetI), structured volume meshes (MiScalardSetIjk) 
*      and structured surface meshes (MiScalardSetIj) are stored in the same list.  
*
* @FILE_FORMAT_DEFAULT
*    ScalarSet {
*    @TABLE_FILE_FORMAT
*    @TABLE_END
*    }
*
* @ACTION_BEHAVIOR
*   Adds a scalar set to the scalar set list.  See MoScalarSetElement.
*
* @SEE_ALSO
*   MoScalarSetElement, MiScalardSetI, MiScalardSetIj, MiScalardSetIjk 
* 
*/
class MESHVIZXLM_DMAP_API MoScalarSet : public MoActionNode {

  SO_NODE_HEADER(MoScalarSet) ;
  
 public:

  /**
   * Constructor.
   */
  MoScalarSet() ;

   /**
   * Provides a common interface for setting any scalar set type (MiScalardSetI, 
   * MiScalardSetIj or MiScalardSetIjk) and marks the node as modified by calling touch().
   * The given scalarSet is checked to ensure that a required type is provided. If not,
   * NULL is set instead.
   * @note When setting a new scalar set, the MiScalardSet::getTimeStamp() must return a different
   * value than previously to actually take into account the change of scalar set.
   */
  virtual void setScalarSet(const MiScalardSet* scalarSet);

  /**
  * Reset the associated scalar set to null (as if setScalarSet was called with null). 
  * Marks the node as modified by calling touch()
  */
  virtual void reset();

  /**
   * Gets the associated scalar set interface.
   * Use RTTI to find out which derived class it is.
   */
  virtual const MiScalardSet* getScalarSet();

  /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
  static void exitClass() ;

  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

protected:
  virtual ~MoScalarSet() ;

  const MiScalardSet* m_scalarSet;

} ; 

#endif /* _MoScalarSet_H  */

