/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MO_SCALARSETI_
#define  _MO_SCALARSETI_

#include <Inventor/fields/SoSFVec3f.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/nodes/SoNode.h>

#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/mapping/nodes/MoActionNode.h>

/**
* @DTEXT Property node that stores a scalar data set for an unstructured mesh.
* 
* @ingroup MeshVizXLM_Mapping_Attributes
* 
* @DESCRIPTION
*    This node adds a reference to an object implementing the MiScalardSetI interface to the 
*    list of unstructured scalar sets in the traversal state.
*
*    Subsequent mesh representations will be able to use this data set for extraction,
*    coloring, etc. During traversal of the scene graph, MoScalarSetI nodes are accumulated 
*    into a list so that an extraction can retrieve several scalar sets during the same 
*    computation. For example, the first set (located at index 0 in the list) for computing 
*    an isosurface and the second set (located at index 1) for coloring it.
*
*    Note: 
*    - Scalar sets for unstructured meshes (MiScalardSetI), structured volume meshes (MiScalardSetIjk) 
*      and structured surface meshes (MiScalardSetIj) are stored in separate lists.  
*    - Use of MoScalarSet is recommended over this node.
*
* @FILE_FORMAT_DEFAULT
*    ScalarSetI {
*    @TABLE_FILE_FORMAT
*    @TABLE_END
*    }
*
* @ACTION_BEHAVIOR
*   Adds a scalar set to the unstructured scalar set list.  See MoScalarSetElementI.
*
* @SEE_ALSO
*   MoScalarSet, MoScalarSetIj, MoScalarSetIjk
* 
*/
class MESHVIZXLM_DMAP_API MoScalarSetI : public MoActionNode {

  SO_NODE_HEADER(MoScalarSetI) ;
  
 public:

  /**
   * Constructor.
   */
  MoScalarSetI() ;

  /**
   * Sets the scalar set interface.
   */
  virtual void setScalarSet(const MiScalardSetI* scalarSet) { m_scalarSet = scalarSet; };

  /**
   * Gets the scalar set interface.
   */
  virtual const MiScalardSetI* getScalarSet() { return m_scalarSet; };

 /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

 protected:
  virtual ~MoScalarSetI() ;

  const MiScalardSetI* m_scalarSet;

} ; 

#endif /* _MO_SCALARSET_  */

