/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MoTessellator_
#define  _MoTessellator_

#include <MeshVizXLM/mapping/nodes/MoActionNode.h>
#include <MeshVizXLM/mapping/MoMeshVizDataMapping.h>

class MiTessellator;

/**
 * @DTEXT Property node that defines a tessellator.
 * 
 * @ingroup MeshVizXLM_Mapping_Attributes
 * 
 * @DESCRIPTION 
 * This node stores an object implementing a tessellator interface in the scene graph. 
 *
 * Tessellator interfaces are used for creating an approximated graphical representation 
 * of a mesh supporting tesselation such as quadratic meshes. 
 * Representation nodes are using a basic tessellator (see MiTessellator) if no MoTessellator node
 * is provided in the scenegraph. However, the MoMeshSurface and MoMeshLine nodes, which do not perform any extractions,
 * require both a mandatory tessellator for proper rendering of quadratic meshes.
 *
 * @note Each time the current MiTessellator is updated, touch() must be called
 * to mark the node as modified. However MiTessellator::getTimeStamp() must return 
 * a different value than before to actually trigger a new rendering.
 *
 * @note Providing a tesselator for a non-quadratic mesh has no effect.
 *
 * @FILE_FORMAT_DEFAULT
 *    Tessellator {
 *    @TABLE_FILE_FORMAT
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *  MiTesselator, MoMeshSurface, MoMeshLine
 *
 */
class MESHVIZXLM_DMAP_API MoTessellator : public MoActionNode {

  SO_NODE_HEADER(MoTessellator) ;
  
 public:

  /**
   * Constructor.
   */
  MoTessellator() ;

  /**
   * Sets the tessellator interface. Sets the node as modified by calling touch().
   * When setting a new tessellator, the MiTessellator::getTimeStamp() must return a different
   * value than previously to actually take into account the change of tessellator.
   */
  virtual void setTessellator(MiTessellator* Tessellator);
  
  /**
   * Gets the Tessellator interface.
   */
  virtual MiTessellator* getTessellator();

 /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;
  
  SoEXTENDER public:
  virtual void  doAction(SoAction *action) ;

protected:
  virtual ~MoTessellator() ;

private:
  MiTessellator* m_tessellator;
  size_t m_timeStamp;
} ; 

#endif /* _MoTessellator_  */

