#ifndef HIDDEN_FROM_DOC

/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

/*=======================================================================

***********************INTERNAL USE ONLY*********************************

*********************** DO NOT USE **************************************

**=======================================================================*/

#ifndef _MO_MESHBUMPSURFACE_
#define _MO_MESHBUMPSURFACE_

#include <MeshVizXLM/mapping/nodes/MoMeshSurface.h>

/**
* @DTEXT  INTERNAL USE ONLY, Rendering node that displays a bump mapped surface.
* 
* @ingroup MeshVizXLM_Mapping_Representation
* 
* @DESCRIPTION
*  A bump mapped surface is based on an unstructured surface mesh. This surface is 
*  rendered using a bump mapping method, using a bump factor parameter to compute 
*  the bump value.
*
* @FILE_FORMAT_DEFAULT
*    MeshBumpSurface {
*    @TABLE_FILE_FORMAT
*       @TR colorScalarSetId           @TD 0
*       @TR bumpFactor                 @TD 10.0
*       @TR parallel                   @TD TRUE
*    @TABLE_END
*    }
*
* @SEE_ALSO
*  MoCellFilter, MoColorMapping, MoDrawStyle, MoMaterial
* 
*/
class MESHVIZXLM_DMAP_API MoMeshBumpSurface : public MoMeshSurface
{
  SO_NODE_HEADER( MoMeshBumpSurface );

public:

  /**
   * Constructor.
   */
  MoMeshBumpSurface();

  /**
   * The bumpFactor can be set to control bump mapping value.
   */
  SoSFFloat bumpFactor;

  /*----------------------------------------------------------------------------*/
  SoINTERNAL public:
  static void initClass() ;
  static void exitClass() ;

protected:

  /**
   * Destructor.
   */
  virtual ~MoMeshBumpSurface();

};

#endif

#endif //HIDDEN_FROM_DOC
