/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MILINEMESHCURVILINEAR_H
#define _MILINEMESHCURVILINEAR_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiMeshUnstructured.h>
#include <MeshVizXLM/mesh/topology/MiTopologyI.h>

/**
* @DTEXT Curvilinear Line mesh abstract interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*    This interface specifies a line defined by a list of points connected by edges forming a broken line. 
*    Curvilinear Line meshes do not contain an explicit description for each cell as is the case for unstructured line meshes.
*
* @SEE_ALSO
*  MiLineMeshRegular, MiLineMeshUnstructured
*
*/
class MESHVIZXLM_EXTR_API MiLineMeshCurvilinear : virtual public MiMeshUnstructured
{
public:
  /**
  * Returns the topology of this mesh.
  */
  virtual const MiTopologyI& getTopology() const = 0;

protected: //PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */
  virtual std::ostream& toStream(std::ostream& s) const
  {
    size_t numCell = getTopology().getNumCells();
    s << "#num cell " << std::endl;
    s << numCell << std::endl;
    s << "#mesh geometry" << std::endl;
    if(numCell)
      for(size_t i=0; i<=getTopology().getNumCells();i++)
        s << i <<": " <<getGeometry().getCoord(i)<< std::endl;
    return s;
  }

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


