/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MILINEMESHREGULAR_H
#define _MILINEMESHREGULAR_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiMesh.h>
#include <MeshVizXLM/mesh/MiMeshRegular.h>

class MiGeometryRegular;
class MiTopologyI;


/**
* @DTEXT Regular line mesh abstract interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*   This interface defines a regular line mesh. 
*   This is a straight line subdivided into getNumCells() segment cells of equal size.
*   The number of cells is given by getNumCells(), in the MiTopologyI interface.
*   The bounds of this line are given by getMin() and getMax() 
*   inherited from MiMeshRegular::getGeometry(). 
*
* @SEE_ALSO
*  MiLineMeshCurvilinear, MiLineMeshUnstructured
*
*/
class MESHVIZXLM_EXTR_API MiLineMeshRegular : virtual public MiMeshRegular
{
public:
  /**
  * Returns the topology of this mesh.
  */
  virtual const MiTopologyI& getTopology() const = 0;

protected: //PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */
  virtual std::ostream& toStream(std::ostream& s) const { return s;}

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


