/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MiMeshIjk_H
#define _MiMeshIjk_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiMesh.h>
#include <MeshVizXLM/mesh/topology/MiTopologyIjk.h>

/**
* @DTEXT IJK volume mesh abstract interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*    This interface defines an IJK volume mesh. All IJK meshes 
*    have a common topology interface to get the number of cells: getNumCellsI(),
*    getNumCellsJ() and getNumCellsK().
* 
*    @see MiVolumeMeshRectilinear
*    @see MiVolumeMeshCurvilinear
*    @see MiVolumeMeshRegular
*    @see MiVolumeMeshHexahedronIjk
*    @see MiVolumeMeshVertexHexahedronIjk
* 
*/
class MESHVIZXLM_EXTR_API MiMeshIjk : virtual public MiMesh
{
public:

  /**
  * Hint about data organization in memory. 
  * This information aims at optimizing the data traversal for extractors.
  * Enum values covering all possible cases for internal data layout in memory.  
  * For instance LAYOUT_KJI means that: 
  *   - data (i+1,j,k) is consecutive in memory to the data (i,j,k) and,
  *   - the row of data (j+1,k) is consecutive in memory to the row of data (j,k) and,
  *   - the slice of data (k+1) is consecutive in memory to the slice of data (k) 
  * The fastest way to go through the data with such layout is to perform the following triple loop
  * @verbatim
    for each k with 0 <= k < numK
      for each j with 0 <= j < numJ
        for each i with 0 <= i < numI
    @endverbatim
  */
  enum StorageLayout { 
    LAYOUT_IJK, LAYOUT_IKJ,
    LAYOUT_JKI, LAYOUT_JIK, 
    LAYOUT_KJI, LAYOUT_KIJ,
    LAYOUT_UNKNOWN
  } ;

  /**
  * Returns the topology of this mesh.
  */
  virtual const MiTopologyIjk& getTopology() const = 0;

protected: //PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */
  virtual std::ostream& toStream(std::ostream& s) const 
  { 
    s << "#mesh topology" << std::endl;
    s << "#numCellsI" << std::endl;
    s << getTopology().getNumCellsI() << std::endl;
    s << "#numCellsJ" << std::endl;
    s << getTopology().getNumCellsJ() << std::endl;
    s << "#numCellsK" << std::endl;
    s << getTopology().getNumCellsK() << std::endl;
    return s;
  }

};

#endif


