/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIVOLUMEMESHCURVILINEAR_H
#define _MIVOLUMEMESHCURVILINEAR_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiMeshIjk.h>
#include <MeshVizXLM/mesh/geometry/MiGeometryIjk.h>

/**
* @DTEXT Curvilinear volume mesh abstract interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*    A Curvilinear volume mesh is similar to a MiVolumeMeshIJK except that nodes are 
*    organized in a (NUMI+1,NUMJ+1,NUMK+1) array where they can be accessed by (i,j,k) indices.
*    So each node located inside the mesh (not on a border) is shared by eight cells. 
*    However, the nodes are not evenly spaced as they can be in the MiVolumeMeshRectilinear or MiVolumeMeshRegular.
*
*    @see MiVolumeMeshHexahedronIjk for IJK meshes where adjacent cells do not share points.
*    @note Notice that, the virtual methods are the same as in the parent class. 
*    The RTTI system is used by some extraction algorithms to identify the mesh type in order to implement some specific 
*    optimization based on the properties described above. 
* 
* @SEE_ALSO
*  MiVolumeMeshRectilinear, 
*  MiVolumeMeshRegular, 
*  MiVolumeMeshUnstructured,
*  MiVolumeMeshHexahedronIjk,
*  MiVolumeMeshVertexHexahedronIjk
*
*/
class MESHVIZXLM_EXTR_API MiVolumeMeshCurvilinear : virtual public MiMeshIjk
{
public:
  /**
  * Returns the geometry of this mesh. 
  */
  virtual const MiGeometryIjk& getGeometry() const = 0;

protected: //PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */
  virtual std::ostream& toStream(std::ostream& s) const 
  { 
    s << "#MiVolumeMeshCurvilinear" << std::endl;
    s << getTopology() << std::endl;
    s << getGeometry() << std::endl;
    return s;
  }
};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


