/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIVOLUMEMESHUNSTRUCTURED_H
#define _MIVOLUMEMESHUNSTRUCTURED_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>
#include <MeshVizXLM/mesh/MiMeshUnstructuredI.h>
#include <MeshVizXLM/mesh/topology/MiVolumeTopologyExplicitI.h>
#include <Inventor/STL/vector>



/**
* @DTEXT Unstructured volume mesh abstract interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*    This interface defines an unstructured volume mesh. It can contain any type of 
*    volume cell, like tetrahedrons, hexahedrons etc.
* 
* @SEE_ALSO
*  MiVolumeMeshCurvilinear,
*  MiVolumeMeshRectilinear, 
*  MiVolumeMeshRegular, 
*  MiVolumeMeshHexahedronIjk,
*  MiVolumeMeshVertexHexahedronIjk
*
*/
class MESHVIZXLM_EXTR_API MiVolumeMeshUnstructured : virtual public MiMeshUnstructuredI
{
public:
  /**
  * Returns the topology of this mesh. 
  */
  virtual const MiVolumeTopologyExplicitI& getTopology() const = 0;

protected: //PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */
  virtual std::ostream& toStream(std::ostream& s) const 
  {
    s << "#MiVolumeMeshUnstructured" << std::endl;
    s << getTopology() << std::endl;
    s << "#mesh geometry" << std::endl;
    for(size_t i=getTopology().getBeginNodeId(); i<getTopology().getEndNodeId(); ++i)
      s << i << ": " << getGeometry().getCoord(i) << std::endl;
    return s;
  }

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


