/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MiVolumeMeshVertexHexahedronIjk_H
#define _MiVolumeMeshVertexHexahedronIjk_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiMeshIjk.h>
#include <MeshVizXLM/mesh/geometry/MiGeometryHexahedronIjk.h>

/**
* @DTEXT  Non Indexed Hexahedron mesh IJK abstract interface.
* 
* @ingroup MeshVizXLM_Mesh
* 
* @DESCRIPTION
*    This interface defines a structured mesh as a 3D grid of hexahedrons. Each hexahedron is defined 
*    by 8 explicit coordinates. This mesh type does not use indexed vertices, so the topology of the mesh
*    is just the I, J and K dimensions of the 3D grid (see MiTopologyIjk).
*
*    The geometry of this mesh explicitly defines the 8 vertices for each hexahedron (i,j,k) where i,j,k 
*    are indices of the hexahedron in the grid. As each hexahedron is defined by its own 8 vertices, 
*    this type of mesh is useful to define "faults" as in a petroleum reservoir model. For instance if the  
*    top vertices of the hexahedron (i,j,k) are not equal to the bottom vertices of the 
*    hexahedron (i,j,k+1), a fault exists between these 2 cells.
*  
*    This type of mesh is similar to an MiVolumeMeshCurvilinear except that the geometry explicitly defines 
*    every vertex of every cell. If all hexahedrons in a MiVolumeMeshVertexHexahedronIjk mesh share 
*    their vertices with their adjacent cells, then a MiVolumeMeshCurvilinear is more appropriate 
*    and is more efficient.
* 
*    This type of mesh is also similar to MiVolumeMeshHexahedronIjk, but each hexahedron is defined
*    by 8 coordinates instead of 8 indices.
*
*    As no vertex indices are defined, this type of mesh can handle only PER_CELL data sets 
*    (see MiDataSet::getBinding()). Extractors will throw an std::exception if trying to use
*    a PER_NODE binding on data sets.
*
*    @note Limitation: This mesh interface is only supported by the MiSkinExtractIjk, MiPlaneSliceExtractIjk
*          and MiIsosurfExtractIjk extractor
*          classes and the MoMeshSkin, MoMeshSlab, MoMeshPlaneSlice and MoMeshIsosurface representation nodes.
*  
*  @see MiGeometryHexahedronIjk to define the geometry of this mesh.
*  @see MiTopologyIjk to define the topology of this mesh. @BR
*  @see MiVolumeMeshHexahedronIjk for IJK meshes where hexahedrons are defined by indices.
*  @see MiVolumeMeshCurvilinear for IJK meshes where adjacent cells share the same points.
*  
* 
*/
class MESHVIZXLM_EXTR_API MiVolumeMeshVertexHexahedronIjk : virtual public MiMeshIjk
{
public:
  /**
  * Returns the structured geometry of this mesh. 
  */
  virtual const MiGeometryHexahedronIjk& getGeometry() const = 0;

protected://PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */
  virtual std::ostream& toStream(std::ostream& s) const
  {
    MbVec3d v[8];
    s << "#MiVolumeMeshVertexHexahedronIjk" << std::endl;
    s << getTopology() << std::endl;
    s << "#mesh geometry" << std::endl;
    for(size_t i=0; i<getTopology().getNumCellsI(); ++i)
      for(size_t j=0; j<getTopology().getNumCellsJ(); ++j)
        for(size_t k=0; k<getTopology().getNumCellsK(); ++k)
        {
            getGeometry().getCellCoords(i,j,k,v[0],v[1],v[2],v[3],v[4],v[5],v[6],v[7]);
            s << i << "," << j << "," << k << ": (" << v[0];
            for ( size_t n = 1; n < 8; ++n)
              s << "; " << v[n] << std::endl;
            s << ")" << std::endl;
        }
    return s;
  }

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


