/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MICELLFILTER_H
#define _MICELLFILTER_H

#include <MeshVizXLM/MxMeshVizXLM.h>

/**
* @DTEXT  Interface class defining a cell filter.
* 
* @ingroup MeshVizXLM_Mesh_Cell
* 
* @DESCRIPTION
*   This abstract class specifies the interface used for filtering cells.@BR
*
*   Filtering cells is a way to specify which cells are used and which cells are ignored during the mesh extraction.@BR
*
*   Each class implementing MiCellFilter must implement an
*   acceptCell() method with either 1, 2 or 3 indices as arguments.@BR
*
*   When the acceptCell() method returns false, the cell identified
*   by these indices is not taken into account by the extraction. 
*   It is as if the mesh does not contain this cell.@BR
* 
*   In order to define a custom cell filter, create a class derived 
*   from one of the following classes. 
*
*   The implementation of all the methods of this class must be thread-safe because it might be called concurrently by multiple threads.
*   If the implementation can't be thread-safe, MeshViz XLM must be forced to use only 1 thread.
*   It can be done by calling MiMeshViz::init(1) or MoMeshViz::init(1) or setting the parallel argument
*   to false for each extractor instantiation. For instance by calling MiSkinExtractUnstructured::getNewInstance(&mesh, false);
* 
*   @see MiCellFilterI
*   @see MiCellFilterIj
*   @see MiCellFilterIjk
*
*/
class MESHVIZXLM_EXTR_API MiCellFilter 
{
public:
  virtual ~MiCellFilter() {}

  /**
  * Returns for this filter a unique time stamp across all filters in the application. 
  * When the content of the filter changes, the time stamp must increase. The time stamp 
  * allows extractors to identify this filter and to be aware about any changes to it.
  * @note MxTimeStamp can be used to generate a valid time stamp.
  */
  virtual size_t getTimeStamp() const = 0;
};

#endif 







