/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MICELLFILTERIJK_H
#define _MICELLFILTERIJK_H

#include <MeshVizXLM/mesh/cell/MiCellFilter.h>

/**
* @DTEXT  Interface class defining a cell filter for structured volume meshes.
* 
* @ingroup MeshVizXLM_Mesh_Cell
* 
* @DESCRIPTION
*   This abstract class specifies the interface used for filtering cells on structured volume meshes.@BR
*
*   Filtering cells is a way to specify which cells are used to 
*   build the mesh representation. @BR
*
*   When the method acceptCell(i,j,k) returns false,
*   the cell specified by (i,j,k) is not taken into account by the extraction. 
*   It is as if the mesh does not contain this cell.@BR
* 
*   In order to define a custom cell filter for a structured volume mesh, create a class derived 
*   from this class. 
*
*   The implementation of all the methods of this class must be thread-safe because it might be called concurrently by multiple threads.
*   If the implementation can't be thread-safe, MeshViz XLM must be forced to use only 1 thread.
*   It can be done by calling MiMeshViz::init(1) or MoMeshViz::init(1) or setting the parallel argument
*   to false for each extractor instantiation. For instance by calling MiSkinExtractUnstructured::getNewInstance(&mesh, false);
*
* @SEE_ALSO
*   MoCellFilter
* 
*/
class MESHVIZXLM_EXTR_API MiCellFilterIjk : virtual public MiCellFilter
{
public:
  /**
  * Returns true if the cell is accepted. Accepted cells are used to during the extract process.
  * @param (i,j,k) indexes of the cell to be checked.
  */
  virtual bool acceptCell(size_t i, size_t j, size_t k) const =0;
};



#endif







