/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MILINECELL_H
#define _MILINECELL_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/cell/MiCell.h>

/**
* @DTEXT  Defines an abstract cell of a line mesh.
* 
* @ingroup MeshVizXLM_Mesh_Cell
* 
* @DESCRIPTION
*    A line cell is an edge element that connects adjacent nodes of a line mesh.
*    This class defines the method getSubEdgeNodesIndex() that is only useful for 
*    non linear 1D cells. For linear 1D cells, the application must just provide
*    the implementation of the methods defined in MiCell without overriding
*    getSubEdgeNodesIndex().
*    
*    When the result of getSubEdgeNodesIndex() is > 0, the cell is considered as a 
*    non linear cell. In that case, the given sub segments are used by the miscellaneous 
*    extractors (for instance MiTessellatedLineExtract). Furthermore if a 
*    MiTessellator is given, each sub segment is tessellated by the method 
*    MiTessellator::tessellateLineCell().
*
*   The implementation of all the methods of this class must be thread-safe because it might be called concurrently by multiple threads.
*   If the implementation can't be thread-safe, MeshViz XLM must be forced to use only 1 thread.
*   It can be done by calling MiMeshViz::init(1) or MoMeshViz::init(1) or setting the parallel argument
*   to false for each extractor instantiation. For instance by calling MiSkinExtractUnstructured::getNewInstance(&mesh, false);
* 
*  @see MiTessellator, MbLineCell, MeXLineCell
*/

class MESHVIZXLM_EXTR_API MiLineCell : public MiCell
{
public:
  /**
  * Get a decomposition of this cell into sub linear segments. @BR
  *
  * This method must be overridden to correctly handle 
  * non-linear cells. For instance an implementation of this method for a quadratic 
  * bar like the following one
  *   @IMAGE QuadraticBar3.png Quadratic bar
  * should return 2, and edgeNodeIds = {0,2,2,1}. 
  * (provided that getNodeIndex(2) corresponds to the middle point of this bar).@BR
  *
  * By default it returns 0 and the argument edgeNodeIds is not modified.
  * @param[out] edgeNodeIds  sub edge node id (where: 0 <= edgeNodeIds[i] < getNumNodes() for each i).
  * @return the number of sub linear segments in this cell.
  */
  virtual size_t getSubEdgeNodesIndex(std::vector<size_t>& SO_UNUSED_PARAM(edgeNodeIds)) const 
  {
    return 0;
  }

};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif

