/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIDATASET_H
#define _MIDATASET_H

#include <Inventor/STL/string>
#include <Inventor/STL/iostream>

#include <MeshVizXLM/MxMeshVizXLM.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT Generic data set interface.
* 
* @ingroup MeshVizXLM_Mesh_DataSets
* 
* @DESCRIPTION
*    A generic abstract interface for a data set usable in any extract of a mesh.
* 
*/
class MESHVIZXLM_EXTR_API MiDataSet
{
public:
  virtual ~MiDataSet() {}

  /**
  * Returns for this dataset a unique time stamp across all datasets in the application. 
  * When the content of the dataset changes, the time stamp must increase. The time stamp
  * allows extractors to identify this dataset and to be aware of any changes to it.
  * @note MxTimeStamp can be used to generate a valid time stamp.
  */
  virtual size_t getTimeStamp() const = 0;

  /**
  * Returns the name of this data set.
  */
  virtual std::string getName() const = 0;

  /** Data binding */
  enum DataBinding {
    PER_CELL, /**< The data set contains one data value per cell. */
    PER_NODE  /**< The data set contains one data value per node. */
  };

  /**
  * Returns the data binding of this data set.
  */
  virtual DataBinding  getBinding() const = 0;

  /**
  * @copydoc MiMesh::operator<<()
  */
  friend std::ostream& operator<< (std::ostream& s, const MiDataSet& dataset)
  {
    return dataset.toStream(s);
  }

protected: //PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */
  virtual std::ostream& toStream(std::ostream& s) const 
  {
    s << "# dataset name" << std::endl; 
    s << getName() << std::endl; 
    return s;
  }

};

#endif


