/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIDATASETIJ_H
#define _MIDATASETIJ_H

#include <MeshVizXLM/MxMeshVizXLM.h>
#include <MeshVizXLM/mesh/data/MiTypedDataSet.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT Generic data set interface for structured surface meshes.
* 
* @ingroup MeshVizXLM_Mesh_DataSets
* 
* @DESCRIPTION
*    A generic abstract template interface for a data set usable in any extract of a structured surface mesh.
* 
*/
template <typename _T>
class MiDataSetIj : virtual public MiTypedDataSet<_T>
{
public:
  /**
  * Returns the ij-th value of this set.
  */
  virtual _T get(size_t i, size_t j) const = 0;
};

template class MESHVIZXLM_EXTR_API MiDataSetIj<double>;

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for structured scalar sets containing double
*/
typedef MiDataSetIj<double>  MiScalardSetIj;

template class MESHVIZXLM_EXTR_API MiDataSetIj<MbVec3d>;

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for structured vector sets containing MbVec3d
*/
typedef MiDataSetIj<MbVec3d> MiVec3dSetIj;

//! @cond Doxygen_Suppress
template class MESHVIZXLM_EXTR_API MiDataSetIj<std::string>;
//! @endcond

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for structured string sets containing std::string
*/
typedef MiDataSetIj<std::string> MiStringSetIj;

#endif

