/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIDATASETIJK_H
#define _MIDATASETIJK_H

#include <MeshVizXLM/MxMeshVizXLM.h>
#include <MeshVizXLM/mesh/data/MiTypedDataSet.h>
#include <MeshVizXLM/mesh/MiMeshIjk.h>

/**
* @DTEXT Generic data set interface for structured volume meshes.
* 
* @ingroup MeshVizXLM_Mesh_DataSets
* 
* @DESCRIPTION
*    A generic abstract template interface for a data set usable in any extract of a structured volume mesh.
* 
*/
template <typename _T>
class MiDataSetIjk : virtual public MiTypedDataSet<_T>
{
public:

  /**
  * Returns the ijk-th value of this set.
  */
  virtual _T get(size_t i, size_t j, size_t k) const = 0;

  /**
  * Hint about data organization in memory. 
  * This information aims at optimizing the dataset traversal for extractors.
  * Returns the internal data layout in memory as 6 enum values covering all possible cases. 
  *
  * For instance LAYOUT_KJI means that: 
  *   - the data (i+1,j,k) is consecutive in memory to the data (i,j,k) and,
  *   - the row of data (j+1,k) is consecutive in memory to the row of data (j,k) and,
  *   - the slice of data (k+1) is consecutive in memory to the slice of data (k) 
  *
  * The fastest way to go through the data with LAYOUT_KJI should be to perform the following triple loop:
  * @verbatim
    for each k with 0 <= k < numK
     for each j with 0 <= j < numJ
       for each i with 0 <= i < numI
         data.get(i,j,k);
    @endverbatim
  * The default implementation returns LAYOUT_UNKNOWN meaning that the data storage organization is unknown, 
  * for instance when data are computed on the fly.
  * In that case, extractors perform the dataset traversal in the way that minimizes the required 
  * memory for their algorithms. 
  */
  virtual MiMeshIjk::StorageLayout getStorageLayout() const { return MiMeshIjk::LAYOUT_UNKNOWN; }

};

template class MESHVIZXLM_EXTR_API MiDataSetIjk<double>;

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for structured scalar sets containing double
*/
typedef MiDataSetIjk<double>  MiScalardSetIjk;

template class MESHVIZXLM_EXTR_API MiDataSetIjk<MbVec3d>;

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for structured vector sets containing MbVec3d
*/
typedef MiDataSetIjk<MbVec3d> MiVec3dSetIjk;

//! @cond Doxygen_Suppress
template class MESHVIZXLM_EXTR_API MiDataSetIjk<std::string>;
//! @endcond

/**
* @ingroup MeshVizXLM_Mesh_DataSets
* Specialization for structured string sets containing std::string
*/
typedef MiDataSetIjk<std::string> MiStringSetIjk;
#endif


