/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIGEOMETRY_H
#define _MIGEOMETRY_H

#include <Inventor/STL/string>
#include <Inventor/STL/iostream>

#include <MeshVizXLM/MxMeshVizXLM.h>
#include <MeshVizXLM/MbVec3.h>
#include <MeshVizXLM/MiAbstractMethodError.h>


/**
* @DTEXT Generic geometry interface.
* 
* @ingroup MeshVizXLM_Mesh_Geometry
* 
* @DESCRIPTION
*    Generic base class of geometry interfaces used by mesh interfaces. 
* 
*/
class MESHVIZXLM_EXTR_API MiGeometry
{
public:
  virtual ~MiGeometry() {}

  /**
  * Returns for this geometry a unique time stamp across all geometries in the application.
  * When the content of the geometry changes, the time stamp must increase. The time stamp 
  * allows extractors to identify this geometry and to be aware of any changes to it.
  * @note MxTimeStamp can be used to generate a valid time stamp.
  */
  virtual size_t getTimeStamp() const = 0;

  /**
  * @copydoc MiMesh::operator<<()
  */
  friend std::ostream& operator<< (std::ostream& s, const MiGeometry& dataset)
  {
    return dataset.toStream(s);
  }

#if SoDEPRECATED_BEGIN(9300)

  /**
  * Returns the minimum value of this set.
  */
  SoDEPRECATED_METHOD_NOWARN(9300,"Do not override this method. It has been moved into MeXGeometry.")
  virtual MbVec3d getMin() const 
  {
    throw MiAbstractMethodError("MiGeometry::getMin()");
  }
  /**
  * Returns the maximum value of this set.
  */
  SoDEPRECATED_METHOD_NOWARN(9300,"Do not override this method. It has been moved into MeXGeometry.")
  virtual MbVec3d getMax() const 
  {
    throw MiAbstractMethodError("MiGeometry::getMax()");
  }

#endif /** @DEPRECATED_END */

protected: //PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */  
  virtual std::ostream& toStream(std::ostream& s) const { return s; }

};

#endif


