/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MIGEOMETRYIJK_H
#define _MIGEOMETRYIJK_H

#include <MeshVizXLM/mesh/MiMeshIjk.h>
#include <MeshVizXLM/mesh/geometry/MiGeometry.h>

/**
* @DTEXT Generic geometry interface for structured volume meshes.
* 
* @ingroup MeshVizXLM_Mesh_Geometry
* 
* @DESCRIPTION
*    Generic geometry interface accessible via three indices.
*    This type of geometry is typically used by structured volume meshes interfaces. 
* 
*/
class MESHVIZXLM_EXTR_API MiGeometryIjk : virtual public MiGeometry
{
public:
  /**
  * Returns the coordinate (i,j,k) of this geometry.
  * The implementation of this method must be thread-safe
  * because it might be called concurrently by multiple threads.
  */
  virtual MbVec3d getCoord(size_t i, size_t j, size_t k) const = 0;

  /**
  * Hint about coordinates organization in memory. 
  * This information aims at optimizing the geometry traversal for extractors.
  * Returns the internal coordinates layout in memory as 6 enum values covering all possible cases. 
  *
  * For instance LAYOUT_KJI means that: 
  *   - the coordinate (i+1,j,k) is consecutive in memory to the coordinate (i,j,k) and,
  *   - the row of coordinates (j+1,k) is consecutive in memory to the row of coordinates (j,k) and,
  *   - the slice of coordinates (k+1) is consecutive in memory to the slice of coordinates (k) 
  *
  * The fastest way to go through the coordinates with LAYOUT_KJI should be to perform the following triple loop:
  * @verbatim
    for each k with 0 <= k < numK
     for each j with 0 <= j < numJ
       for each i with 0 <= i < numI
         coordinates.getCoord(i,j,k);
    @endverbatim
  * The default implementation returns LAYOUT_UNKNOWN meaning that the coordinates storage organization is unknown, 
  * for instance when data are computed on the fly.
  * In that case, extractors perform the geometry traversal in the way that minimizes the required 
  * memory for their algorithms. 
  */
  virtual MiMeshIjk::StorageLayout getStorageLayout() const { return MiMeshIjk::LAYOUT_UNKNOWN; }
};

#endif


