/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MITOPOLOGY_H
#define _MITOPOLOGY_H

#include <Inventor/STL/ostream>
#include <MeshVizXLM/MxMeshVizXLM.h>

//-----------------------------------------------------------------------------
/**
* @DTEXT List of cells interface.
* 
* @ingroup MeshVizXLM_Mesh_Topology
* 
* @DESCRIPTION
*    A generic abstract interface for a mesh topology. 
*
*   The implementation of all the methods of this class must be thread-safe because it might be called concurrently by multiple threads.
*   If the implementation can't be thread-safe, MeshViz XLM must be forced to use only 1 thread.
*   It can be done by calling MiMeshViz::init(1) or MoMeshViz::init(1) or setting the parallel argument
*   to false for each extractor instantiation. For instance by calling MiSkinExtractUnstructured::getNewInstance(&mesh, false);
* 
*/
class MESHVIZXLM_EXTR_API MiTopology 
{
public:
  virtual ~MiTopology() {}

  /**
  * Returns for this topology a unique time stamp across all topologies in the application.
  * When the content of the topology changes, the time stamp must increase. The time stamp 
  * allows extractors to identify this topology and to be aware of any changes to it.
  * @note MxTimeStamp can be used to generate a valid time stamp.
  */
  virtual size_t getTimeStamp() const = 0;

  /** 
  * Returns true if the topology contains dead cells.
  * When false, the cells traversal can be optimized by not testing the isDead() method of each individual cells.
  * The default implementation returns always false.
  */ 
  virtual bool hasDeadCells() const { return false ;}

  /**
  * @copydoc MiMesh::operator<<()
  */
  friend std::ostream& operator<< (std::ostream& s, const MiTopology& topo)
  {
    return topo.toStream(s);
  }

protected://PROTECTED_TO_DOCUMENT
  /**
  * @copydoc MiMesh::toStream(std::ostream& s) const
  */ 
  virtual std::ostream& toStream(std::ostream& s) const { return s;}
};


#endif


