/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MITOPOLOGYI_H
#define _MITOPOLOGYI_H

#include <MeshVizXLM/mesh/topology/MiTopology.h>

#include <Inventor/STL/sstream>

//-----------------------------------------------------------------------------
/**
* @DTEXT List of cells interface.
* 
* @ingroup MeshVizXLM_Mesh_Topology
* 
* @DESCRIPTION
*    A generic abstract interface for an implicit mesh topology. 
*
*   The implementation of all the methods of this class must be thread-safe because it might be called concurrently by multiple threads.
*   If the implementation can't be thread-safe, MeshViz XLM must be forced to use only 1 thread.
*   It can be done by calling MiMeshViz::init(1) or MoMeshViz::init(1) or setting the parallel argument
*   to false for each extractor instantiation. For instance by calling MiSkinExtractUnstructured::getNewInstance(&mesh, false);
* 
*/
class MESHVIZXLM_EXTR_API MiTopologyI : virtual public MiTopology
{
public:
  /**
  * Returns the number of cells.
  */
  virtual size_t getNumCells() const = 0;

 /** 
  * Returns true if the cell of index i should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * The default implementation returns always false.
  * The implementation of this method must be thread-safe
  * because it might be called concurrently by multiple threads.
  *
  * @param i the index of the cell to check
  */ 
  virtual bool isDead(size_t SO_UNUSED_PARAM(i)) const { return false ;}

protected:
  /**
  * Defines a specialized output on stream 
  */
  virtual std::ostream& toStream(std::ostream& s) const
  { 
    s << "#mesh topology" << std::endl;
    s << "#numCells" << std::endl;
    s << getNumCells() << std::endl;
    s << "#hasDeadCells" << std::endl;
    s << hasDeadCells() << std::endl;
    return s;
  }
};


#endif


