/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MiEdgeErrorMetric_h
#define  _MiEdgeErrorMetric_h

#include <MeshVizXLM/MbVec3.h>
class MiCell;

/**
 * @DTEXT Edge error metric interface used by the tessellator.
 * 
 * @ingroup MeshVizXLM_Extract_Tessellate
 * 
 * @DESCRIPTION 
 *   This class is used to check if an edge can be considered as linear or not.
 *   The isEdgeLinear method is called by the tessellator in order to estimate the quality of 
 *   an edge tessellation and thus the quality of the mesh tessellation.
 *   
 *   @note In order to have a "crack free" tesselation (tessellation without any small
 *   gaps along the edges) the method isEdgeLinear() must be symmetric: 
 *   calling isEdgeLinear(O,P,Q) must return the same result as calling isEdgeLinear(P,O,Q).
 *
 *   See MxEdgeErrorMetricGeometry for an example of implementation of this interface. 
 *   It defines a geometrical criterion by using only the coordinates of an edge to 
 *   check if it could be seen as linear or not.
 *
 *   @see MiTessellator
 * 
 *
 */
template <typename _T>
class MiEdgeErrorMetric
{
public:
  virtual ~MiEdgeErrorMetric() {}

  /**
  * Checks if an edge can be seen as linear or not according to its coordinates or its values.
  * 
  * Given 2 values v0,v1 at the end points of the edge, and one value vM at the theoretical middle point
  * of the edge, the method returns true if the edge can be seen as linear.
  *
  * @param [in]  v0 value at the first end point of the edge.
  * @param [in]  v1 value at the second end point of the edge.
  * @param [in]  vM value at the theoretical middle point of the edge.
  * @return true if the edge can be seen as linear.
  */
  virtual bool isEdgeLinear(const _T& v0, const _T& v1, const _T& vM) const = 0;

  /**
  * Returns a time stamp on this edge error metric. Whenever any parameter used 
  * by the application method isEdgeLinear() changes, the time stamp must increase. 
  */
  virtual size_t getTimeStamp() const = 0;

};

#endif


