/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MxEdgeErrorMetricGeometry_h
#define _MxEdgeErrorMetricGeometry_h

#include <MeshVizXLM/MbVec3.h>
#include <MeshVizXLM/MiMeshViz.h>
#include <MeshVizXLM/tessellator/MiEdgeErrorMetric.h>
#include <MeshVizXLM/MxTimeStamp.h>

/**
* @DTEXT Geometrical edge error metric.
* 
* @ingroup MeshVizXLM_Extract_Tessellate
* 
* @DESCRIPTION 
*   This class is an example implementation of the interface MiEdgeErrorMetric.
*   It is used to check if an edge can be considered linear or not based on 
*   the coordinates of its end points coord0 and coord1, the coordinate coordM 
*   of the parametric middle point, and a tolerance factor maxError. 
* 
*   This class can be used as an argument to the method 
*   MiTessellator::getNewTessellatorGeometry().
*   
*   @see MiTessellator
*
*/
class MESHVIZXLM_EXTR_API MxEdgeErrorMetricGeometry : public MiEdgeErrorMetric<MbVec3d>
{
public:

  /**
  * Constructor that sets the tolerance factor maxError.
  */
  MxEdgeErrorMetricGeometry(double maxError) 
    : m_maxError(maxError), m_timeStamp(MxTimeStamp::getTimeStamp())
  {}

  /**
  * Check if 3 points are linear based on their coordinates and the tolerance factor maxError.
  * If the method returns true, the segment defined by [coord0,coordM,coord1] is considered to
  * be linear by the geometrical tessellator (see MiTessellator).
  *    @IMAGE MxEdgeErrorMetricGeometry.png the segment is linear if d < maxError
  *
  * @param [in]  coord0 coordinate of the first end point of the segment.
  * @param [in]  coord1 coordinate of the second end point of the segment.
  * @param [in]  coordM coordinate corresponding the theoretical middle point of the segment.
  * @return true if the distance from the point coordM to the segment [coord0,coord1] < maxError
  */
  virtual bool isEdgeLinear(const MbVec3d& coord0, const MbVec3d& coord1, const MbVec3d& coordM) const;

  /**
  * Set the tolerance factor maxError. @BR This method also updates the time stamp of the 
  * current instance of MxEdgeErrorMetricGeometry.
  * @param[in] maxError new value of the tolerance factor.
  */
  void setMaxError(double maxError)
  {
    m_maxError = maxError;
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }

  /**
  * Returns the current time stamp on this edge error metric. It changes each time  
  * the method setMaxError() is called.
  */
  virtual size_t getTimeStamp() const 
  {
    return m_timeStamp;
  }

private:
  double m_maxError;
  size_t m_timeStamp;
};

#endif


