/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/sys/port.h>

#include <RemoteViz/Rendering/FrameEncoders.h>
#include <SoDeprecationRules.h>

#include <memory>

namespace RemoteViz
{
  namespace Rendering
  {

    class IFrameEncodingPolicy;
    class ConnectionSettingsImpl;
    /**
     * @RVEXT
     *
     * @ingroup RemoteViz
     *
     * @DESCRIPTION
     *  Settings that define a Connection.
     *
     *  The application can query this object from a Connection object.
     *  The Connection object can obtained in, e.g., RenderAreaListener::onInitializedConnection().
     *
     * [OIVJAVA-WRAPPER-CLASS SHARED_POINTER_USE]
     * [OIVNET-WRAPPER-CLASS AUTO_PROPERTY,SHARED_POINTER_USE]
     */
    class RENDERSERVICE_API ConnectionSettings
    {

      /*! \cond PRIVATE */
      friend class ConnectionImpl;
      /*! \endcond */

    public:

#if SoDEPRECATED_BEGIN(9900)

      //@{
      /**
       *  Sets the frame encoding policy to KeepFrameQualityPolicy (see setFrameEncodingPolicy) and the FPS target value.
       *  The frame quality target is set to the default value (0.7). \n
       *  The FPS threshold is set to the default value (15). \n
       *
       *  The value range is [1..60].
       *
       *  \param value : FPS target.
       */
      SoDEPRECATED_METHOD(9900,"Please use new method setFrameEncodingPolicy instead.")
      void setMaxFPS(unsigned int value);
      /**
       *  Gets the maximum number of frames per second sent to the client. 
       *  This value is from encodingPolicy.getFramePerSecond(); \n
       *  The value range is [1..60].
       *
       *  \return the number of frames per second.
       */
      SoDEPRECATED_METHOD(9900,"Please use new method IFrameEncodingPolicy::getFPS() instead.")
      unsigned int getMaxFPS() const;
      //@}

#endif /** @DEPRECATED_END */

      //@{
      /**
       *  Sets the keepalive timeout (ms). A keepalive is sent by the client every 5 seconds to check that the link between 
       *  the two is operating, or to prevent this link from being broken. Without a keepalive signal, the service 
       *  will drop the connection after timeout with the disconnection message NETWORKFAILURE. 
       *  Default value is 90000.
       *
       *  \param value : the keepalive timeout delay (ms).
       */
      void setKeepAliveTimeOut(unsigned int value);
      /**
       *  Gets the keepalive timeout (ms). A keepalive is sent by the client every 5 seconds to check that the link between the 
       *  two is operating, or to prevent this link from being broken. Without a keepalive signal, the service 
       *  will drop the connection after timeout with the disconnection message NETWORKFAILURE. 
       *  Default value is 90000.
       *
       *  \return the keepalive timeout delay (ms).
       */
      unsigned int getKeepAliveTimeOut() const;
      //@}

      //@{
      /**
       *  Gets the frame encoders used by the connection.\n
       *  This value is defined in RenderAreaListener#onOpenedConnection.
       *
       *  \return the frame encoders.
       */
      std::shared_ptr<const FrameEncoders> getFrameEncoders() const;

      /**
       *  Returns if encoders are supported by the host.\n
       *
       *  \param frameEncoders : frame encoders
       *
       *  \return true if supported, if not, the status of encoders explain the reason
       */
      bool isSupportedEncoders(std::shared_ptr<const FrameEncoders> frameEncoders) const;
      //@}

      //@{
      /**
       *  Sets the frame encoding policy used by the Connection.
       *  A policy is used to calculate two values: FPS (frames per second) and interactive frame encoding quality.
       *  There are two predefined policies: KeepFramesPerSecondPolicy and KeepFrameQualityPolicy.
       *  The default value is KeepFrameQualityPolicy with default parameters.  (Replaces the old setMaxFPS method.)
       *
       *  \param policy : a frame encoding policy object.
       *
       *  [OIV-WRAPPER NO_PROPERTY]
       */
      void setFrameEncodingPolicy(std::shared_ptr<IFrameEncodingPolicy> policy);
      //@}


    protected:
      /*! \cond PRIVATE */
      /** Returns a pointer to implementation */
      std::shared_ptr<ConnectionSettingsImpl> getImpl() const;
      /*! \endcond */

    private:
      /** Constructor */
      ConnectionSettings();

      /** Deleted constructors */
      ConnectionSettings(const ConnectionSettings&) = delete;
      ConnectionSettings& operator= (const ConnectionSettings&) = delete;

      /** Pointer to implementation */
      std::shared_ptr<ConnectionSettingsImpl> pImpl;
    };

  }
}
