/*=======================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
***                                                                                ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
***                                                                                ***
***                        RESTRICTED RIGHTS LEGEND                                ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
***                                                                                ***
***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
***                        BORDEAUX, FRANCE                                        ***
***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/sys/port.h>

#include <memory>

namespace RemoteViz
{
  namespace Rendering
  {
    class Connection;

    /**
    *  @RVEXT
    *
    *  @ingroup RemoteViz
    *
    *  This class is the base class of KeepFramesPerSecondPolicy and KeepFrameQualityPolicy.
    *  The methods will be called internally by the RemoteViz service to retrieve encoding frame 
    *  parameters (FPS and interactive frame quality).
    *
    *  See ConnectionSettings to set the frame encoding policy.
    *
    *  @SEE_ALSO
    *  KeepFramesPerSecondPolicy
    *  KeepFrameQualityPolicy
    *
    *  [OIV-WRAPPER-CLASS SHARED_POINTER_USE]
    */
    class RENDERSERVICE_API IFrameEncodingPolicy
    {
    public:
      /**
      * Destructor
      */
      virtual ~IFrameEncodingPolicy() {}

      /**
      * Update value of the FPS and frame quality.
      */
      virtual void update( std::shared_ptr<Connection> connection ) = 0;

      /**
      * Returns the FPS value used to send frames to the client periodically.
      */
      virtual unsigned int getFramesPerSecond() const = 0;

      /**
      * Returns the frame quality value used to encode interactive frames.
      */
      virtual float getFrameQuality() const = 0;
    };
  }
}
