/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/sys/port.h>
#include <RemoteViz/Rendering/LibHelper.h>

#include <memory>
#include <string>

namespace RemoteViz
{
  namespace Rendering
  {

    class RenderAreaHardwareImpl;

    /**
     * @RVEXT
     *
     * @ingroup RemoteViz
     *
     * @DESCRIPTION
     *  Settings to setup hardware for a render area.
     *
     * If the application explicitly creates the RenderArea, an instance of this
     * class must be passed to Service#createRenderArea.
     *
     * If the RenderArea is automatically created by RemoteViz, an instance of
     * this class will be passed to the
     * ServiceListener#onPendingCreateRenderArea method and can be
     * used to modify settings (for example which GPU to use for rendering).
     *
     * [OIVJAVA-WRAPPER-CLASS SHARED_POINTER_USE]
     * [OIVNET-WRAPPER-CLASS AUTO_PROPERTY,SHARED_POINTER_USE]
     */
    class RENDERSERVICE_API RenderAreaHardware
    {
      /*! \cond PRIVATE */
      friend class RenderAreaImpl;
      /*! \endcond */

    public:
      /**
      *  Constructor.
      */
      RenderAreaHardware();

      /**
      *  Copy constructor
      */
      RenderAreaHardware(const RenderAreaHardware& obj);

      /**
      *  Copy assignment operator
      */
      RenderAreaHardware& operator=(const RenderAreaHardware& obj);

      /**
      *  Destructor.
      */
      ~RenderAreaHardware();

      //@{
      /**
      *  Sets the Graphics Processing Unit (GPU) used for rendering.
      *
      *  This value can be retrieved using RenderArea#getGpu.
      *
      *  On X11 Linux, the default value is the value of the environment variable DISPLAY,
      *  typically ":0.0". The specification for a specific GPU depends on the X11
      *  configuration file, but usually the first digit is the GPU index.
      *  
      *  On Headless EGL Linux, the default value is EGL_DEFAULT_DISPLAY, typically "0".
      *  The parameter is a GPU index (0..N) (see eglQueryDevicesEXT and eglGetPlatformDisplayEXT).
      *
      *  Limitations:\n
      *  - Currently this feature @I only@i works on Linux.\n
      *    Calling this method on Windows is allowed, but has no effect.
      *
      *  - This feature only works with the modes ServiceSettings#INVENTOR_SERVICE and ServiceSettings#INVENTOR_APPLICATION.
      *
      *  - Currently this feature can @I only@i specify the GPU to be used for rendering.\n
      *    GPU accelerated video encoding, for example H.264, is always done on the GPU with id "0".
      *
      *  \param value : GPU used to compute the render.
      */
      void setGpu(const std::string& value);
      //@}

    protected:
      /*! \cond PRIVATE */
      std::shared_ptr<RenderAreaHardwareImpl> getImpl() const;
      /*! \endcond */

    private:
      /** Pointer to implementation */
      std::shared_ptr<RenderAreaHardwareImpl> pImpl;

    };
  }
}
