/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
/*
 * Module: inttypes.h
 */

#ifndef __oiv_inttypes_h__
#define __oiv_inttypes_h__

#if defined(_WIN32) /* Microsoft WINxx */
#  if !defined(WIN32)
#    define WIN32
#  endif
#  if defined(_WIN64)
#    if !defined(WIN64)
#      define WIN64
#    endif
#  endif
#endif

#ifdef _WIN32 /* Microsoft WINxx */
typedef signed   __int8  int8_t;
typedef unsigned __int8  uint8_t;
typedef signed   __int16 int16_t;
typedef unsigned __int16 uint16_t;
typedef signed   __int32 int32_t;
typedef unsigned __int32 uint32_t;
typedef signed   __int64 int64_t;
typedef unsigned __int64 uint64_t;

#define SO_WCHAR_T unsigned short
# define INT64FMT "%I64d"

#elif defined (__linux__) || defined(__APPLE__) /* Linux or Mac */
/*typedef unsigned int uint32_t; already defined in /usr/include/stdint.h */
#  include <stdint.h>
#endif

#ifndef _WIN32 /* UNIX */
#define SO_WCHAR_T wchar_t

#if defined(__GNUC__) && defined(__LP64__) && (__LP64__ == 1)
# define INT64FMT "%ld"
#else
# define INT64FMT "%lld"
#endif
#endif

#if defined(_WIN64) || _MSC_VER >= 1300
/* nothing */
#elif defined(_WIN32) && !defined(_WIN64) && _MSC_VER < 1300 /* Visual C++ 6.0 */
typedef unsigned uintptr_t;
typedef unsigned long DWORD_PTR;
typedef signed int intptr_t;
#elif defined(__linux__)
/* Linux || HPUX 11.x || SGI O32 || AIX 32 */
typedef unsigned long DWORD_PTR;
#else
typedef unsigned long DWORD_PTR;
#endif

#if defined(_WIN32) && !defined(_WIN64) && _MSC_VER < 1300
#  ifndef SetWindowLongPtr
#    define SetWindowLongPtr SetWindowLong
#  endif
#  ifndef GetWindowLongPtr
#    define GetWindowLongPtr GetWindowLong
#  endif
#  ifndef LONG_PTR
#    define LONG_PTR LONG
#  endif
#  ifndef GWLP_HINSTANCE
#    define GWLP_HINSTANCE GWL_HINSTANCE
#  endif
#  ifndef GWLP_WNDPROC
#    define GWLP_WNDPROC GWL_WNDPROC
#  endif
#  ifndef GWLP_USERDATA
#    define GWLP_USERDATA GWL_USERDATA
#  endif
#  ifndef DWLP_USER
#    define DWLP_USER DWL_USER
#  endif
#endif

#endif /* __oiv_inttypes_h__ */

