/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Oct 2010)
**=======================================================================*/


#ifndef SO_SCALEVIZ_ART_H
#define SO_SCALEVIZ_ART_H

#include <Inventor/SbString.h>

class SoSceneManager;

/**
 *
 * @SCVEXT ScaleViz based Automatic Replay Tool
 * 
 * @ingroup ScaleViz
 * 
 * @DESCRIPTION
 *
 * This class allows user to register a ScaleViz ART scenario.
 * A ART scenario is a set of scene commands, enhanced with snapshot capability.
 * Generated ScaleVizART scenario can be replayed using the ART application.
 *
 */
class SCALEVIZ_API SoScaleVizART
{
public:

  /**
   * Sets the base name for generated ART files.
   * Must be called before calling start();
   */
  static void setTestName( const SbString& );

  /**
   * Gets the current defined base name for generated ART files.
   */
  static SbString getTestName();

  /**
   * Sets the directory where to the ART files will be generated.
   * If defined directory does not exist, it will be created.
   * Must be called before calling start();
   */
  static void setOutputDir( const SbString& );

  /**
   * Gets the current directory where ART files are generated.
   */
  static SbString getOutputDir(); 

  /**
   * Defines whether existing ART files with same names must be overridden or not. 
   * Default is false: An existing file is not overridden.
   */
  static void setOverride( bool );

  /**
   * Returns TRUE if existing ART file with same name can be overridden.
   */
  static bool getOverride();

  /**
   * Start a ART registering session.
   * Returns false if a new session failed to launch.
   */
  static bool start();

  /**
   * Stops the currently running ART session.
   */
  static void stop();

  /**
   * Save a scene graph snapshot.
   * This generates an Open Inventor ASCII formatted file which filename is on the form [name]_[N].iv
   * Where:
   * - [name] is the current ART test name
   * - [N] is an automatic increment generated by ART.
   */
  static void saveSnapshotSceneGraph( SoSceneManager* sceneManager );

  /**
   * Save a scene rendering snapshot image.
   * This generates output an PNG image file which filename is on the form [name]_snapshot[N].png
   * Where:
   * - [name] is the current ART test name
   * - [N] is an automatic increment generated by ART.
   */
  static void saveSnapshotImage( SoSceneManager* sceneManager );

  /**
   * Returns TRUE if ART is currently running.
   */
  static bool isRunning();

SoINTERNAL public:

  //
  // These methods are the pending of setTestName(SbString) and
  // setOutputDir(SbString) but with char* arguments in order
  // to be invoked from PInvoke for .Net
  //

  /**
   * Sets the base name for generated ART files.
   * Must be called before calling start();
   */
  static void setTestName( const char* );

  /**
   * Sets the directory where to the ART files will be generated.
   * If defined directory does not exist, it will be created.
   * Must be called before calling start();
   */
  static void setOutputDir( const char* );
};

#endif // SO_SCALEVIZ_ART_H

/**/

