/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Ludovic PEINE (May 2007)
**=======================================================================*/


#ifndef  SC_GET_BOUNDING_BOX_ACTION
#define  SC_GET_BOUNDING_BOX_ACTION

#include <Inventor/actions/SoGetBoundingBoxAction.h>

class ScGetBoundingBoxAction;
class SbViewportRegion;

typedef void ScGetBoundingBoxCallback( void*, ScGetBoundingBoxAction* );

/**
 * @SCVEXT Defines a distributed bounding box action.
 * 
 * @ingroup ScaleVizAction
 * 
 * @DESCRIPTION
 * 
 * The ScGetBoundingBoxAction class provides a simple way to distribute an SoGetBoundingBoxAction
 * across a cluster. 
 *
 * Several distribution modes are available:
 *    - LOCAL_ONLY: action is only applied by the application. 
 *    - CLUSTER_ONLY: action is only applied by the OIRUs. 
 *    - ALL: both the application and the OIRUs apply the given action.
 *
 * When OIRUs are involved (i.e., in CLUSTER_ONLY and ALL modes), they apply the action 
 * on their own part of the scene graph. The application gets back the result 
 * via the callback defined by the user.
 *
 * This class can be used in all compositing modes (flat, tile, depth, and local compositing).
 *
 * @SEE_ALSO
 *    SoGetBoundingBoxAction
 *
 *
 */
class SCALEVIZ_API ScGetBoundingBoxAction : public SoGetBoundingBoxAction
{
  SO_ACTION_HEADER(ScGetBoundingBoxAction);

public:

  /**
   * Constructor. 
   *
   * @param viewportRegion  viewport region to use for picking 
   * @param distribMode     specifies the way the action should be distributed
   * @param callback        pointer to the function used to get the result of the action
   * @param userData        pointer to user data
   */
  ScGetBoundingBoxAction(
    const SbViewportRegion &viewportRegion,
    SoAction::DistribMode distribMode = SoAction::LOCAL_ONLY,
    ScGetBoundingBoxCallback* callback = NULL, 
    void* userData = NULL );

  /**
   * Destructor
   */
#ifndef HIDDEN_FROM_DOC
  ~ScGetBoundingBoxAction();
#endif // HIDDEN_FROM_DOC

  /**
   *    Applies action to the graph rooted by a node.
   */
  virtual void apply(SoNode *node);

SoINTERNAL public:
  static void initClass();
  static void exitClass();

private:
  // Pointer to the user callback
  ScGetBoundingBoxCallback* m_getBoundingBoxCallback;  

  // Pointer to user data
  void* m_data;
};

#endif // SC_GET_BOUNDING_BOX_ACTION

/**/


