/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (MMM yyyy)
**=======================================================================*/


#ifndef SO_MEMORY_BUFFER_H
#define SO_MEMORY_BUFFER_H

#include <ScaleViz/SoScaleViz.h>

class SoMemoryObject;

SoEXTENDER_Documented class SCALEVIZ_API SoMemoryBuffer
{
public:

  /** Default constructor. */
  SoMemoryBuffer();

  /** constructor form a user memory area */
  SoMemoryBuffer( char* data,
                  const size_t size,
                  const size_t nbElement = 1,
                  char* externalPointer = NULL );

  /** Constructor: take a memory Object (including smart ref pointer) */
  SoMemoryBuffer(SoMemoryObject* memObj);

  /** Destructor */
  virtual ~SoMemoryBuffer();
  
  /** setup functions */
  void setSize( const size_t size, const size_t nbElement = 1 );

  /** Returns size in bytes */
  inline size_t getSize() const;

  /** Returns number of element */
  inline size_t getNbElement() const;

  /** Returns direct pointer to data */
  char* getPointer() const;

  /** Returns external pointer attached to this buffer */
  char* getExternalPointer() const;

private:
  // Size of the buffer 
  size_t m_size;
  size_t m_nbElement;

  // Pointer on the current data
  char* m_data;
  
  // Current internal byte size
  size_t m_ByteSize;

  // Indicate if the internal memory has been allocated outside by the user
  // in this case only the user can free the memory area
  bool m_externalAlloc;

  char* m_externalPointer;

  SoMemoryObject* m_memObj;
};


inline size_t
SoMemoryBuffer::getSize() const
{
  return ( m_size * m_nbElement );
}

inline size_t
SoMemoryBuffer::getNbElement() const
{
  return m_nbElement;
}

inline char*
SoMemoryBuffer::getPointer() const
{
  return m_data;
}

inline char*
SoMemoryBuffer::getExternalPointer() const
{
  return m_externalPointer;
}

#endif // SO_MEMORY_BUFFER_H

/**/


