/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (MMM yyyy)
**=======================================================================*/


#ifndef SOMEMORYBUFFER2D_H
#define SOMEMORYBUFFER2D_H

#include <ScaleViz/misc/SoMemoryBuffer.h>
#include <Inventor/SbVec.h>

SoEXTENDER_Documented class SCALEVIZ_API SoMemoryBuffer2D : public SoMemoryBuffer
{
public:
  /** constructor */
  SoMemoryBuffer2D();
  
  /** setup function */
  void setSize( const unsigned short width, const unsigned short height, const size_t nbElement );

  /** setup function */
  void setSize( const SbVec2s& size, const size_t nbElement );

  /** Returns width */
  inline unsigned short getWidth() const;

  /** Returns height */
  inline unsigned short getHeight() const;

  /** Returns 2D size */
  SbVec2s getSize2D() const;

private:
  // size of the buffer 
  unsigned short m_width;
  unsigned short m_height; 
};


inline unsigned short
SoMemoryBuffer2D::getWidth() const
{
  return m_width;
}

inline unsigned short
SoMemoryBuffer2D::getHeight() const
{
  return m_height;
}

inline SbVec2s
SoMemoryBuffer2D::getSize2D() const
{
  return SbVec2s( m_width, m_height );
}

#endif // SOMEMORYBUFFER2D_H

