/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (MMM yyyy)
**=======================================================================*/


#ifndef SO_MEMORY_BUFFER_COMPRESSION_H
#define SO_MEMORY_BUFFER_COMPRESSION_H

#include <ScaleViz/SoScaleViz.h>

class SoMemoryBuffer;

SoEXTENDER class SCALEVIZ_API SoMemoryBufferCompression
{

public:
  // define the type of compression available
  typedef enum {
    /* No compression */
    NONE,
    /* Zip through zlib compression */
    ZLIB,
    /* bzip compression */
    BZIP2,
    /* per component bzip compression */
    PBZIP2
  } CompressionMode;

public:
  // Constructor
  SoMemoryBufferCompression();

  //Destructor
  virtual ~SoMemoryBufferCompression();
  
  // setup the source buffer of the compression with the possibility
  // to limit the compression to a subset of the buffer with offset and size parameter 
  // if size is set to 0 then the buffer size will be taken minus the offset
  virtual void setSource(SoMemoryBuffer *src,const unsigned long offset=0,const unsigned long size=0);

  // setup the destination buffer of the compression with the possibilty to
  // set a destination offset, allowing the user to add specific infoon the header
  virtual void setDestination(SoMemoryBuffer *dst,const unsigned long offset=0);
  
  // apply a compression function on the defined source offset/size 
  // and put the results in destination at offset
  // return the size of the compressed results 
  // or -1 if error
  int compress(const CompressionMode mode);

  // apply uncompress function on the defined source offset/size 
  // and put the results in destination at offset
  // return the size of the compressed results 
  // or -1 if error
  int uncompress(const CompressionMode mode);

private:
  SoMemoryBuffer* m_srcBuf;
  unsigned long m_srcOffset, m_srcSize;
  
  SoMemoryBuffer* m_dstBuf;
  unsigned long m_dstOffset, m_dstSize;

};

#endif // SO_MEMORY_BUFFER_COMPRESSION_H

/**/


