/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
** Modified by : Paul S. Strauss (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_UNKNOWN_NODE_
#define  _SO_UNKNOWN_NODE_

#include <Inventor/fields/SoFieldData.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/nodes/SoSubNode.h>

class SoSFNode;
class SoMFString;
class SoChildList;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoUnknownNode
//
//  The Unknown Node! This node is created during file reading when a
//  node is read that is unrecognized by Inventor and a DSO cannot be found
//  for it.  Note that even though it is derived from SoGroup, we lie
//  and tell SoType that it is derived from SoNode.  This, along with
//  the fact that users are not shipped this header file (so they
//  can't call SoGroup methods directly), has the effect of making the
//  normally public children hidden.
//
//////////////////////////////////////////////////////////////////////////////

SoINTERNAL class INVENTOR_API SoUnknownNode : public SoGroup {

    SO_NODE_HEADER(SoUnknownNode);

  public:
    // Constructor
    SoUnknownNode();

  SoEXTENDER public:
    virtual void	write(SoWriteAction *action);

  SoINTERNAL public:
    static void		initClass();
    static void		exitClass();
    void                setClassName(const SbString& name);

  protected:
    // Reads field type information, fields, and children.
    virtual SbBool	readInstance(SoInput *in, unsigned short flags);

    // Override search so we don't search alternateRep
    virtual void	search(SoSearchAction *action);

    // Returns file format name
    virtual const char* getFileFormatName() const;

    // Recursively adds this node and all nodes under it to the copy
    // dictionary. Returns the copy of this node.
    virtual SoNode *	addToCopyDict() const;

    // Copies the contents of the given node into this instance
    virtual void	copyContents(const SoFieldContainer *fromFC,
				     SbBool copyConnections);

  private:
    // Used during reading to create an alternateRep from an isA
    // specification.
    void		createFromIsA(SoMFString *isA);

    // Per-instance field data
    SoFieldData		*instanceFieldData;

    // Real class name
    SbString className;

    // List of hidden children.
    SoChildList*		hiddenChildren;
  
    // Destructor
    virtual ~SoUnknownNode();

    // Will be true if read in with children
    SbBool hasChildren;

    //force group alternate representation
    static bool s_forceGroupAlternateRep;
};

#endif /* _SO_UNKNOWN_NODE_ */


