/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2015 BY FEI S.A.S,                        ***
 ***                        MERIGNAC, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _INVENTOR_VERSION_H_
#define _INVENTOR_VERSION_H_

#ifndef HIDDEN_FROM_DOC

/**
 * These symbols can be used to determine what version of Inventor
 * your application is compiling against.  These symbols were first
 * added with Inventor 7.1.0 (SO_VERSION==7, SO_VERSION_REVISION==1);
 * they were undefined in previous revisions of Inventor.
 */

/* x.x.x.x */
#define SO_VERSION                      10
#define SO_VERSION_REVISION             18
#define SO_VERSION_PATCH                1
#define SO_VERSION_BUILD                0
#define SO_VERSION_MAJOR_MINOR          1018

/*
 * SO_COMMERCIAL_VERSION is used to define a product version in terms of date.
 * For example 2023.2.7 for the second version of OIV in 2023 and the 7th patch version.
 */

#define SO_COMMERCIAL_VERSION           2025.2.1
#define SO_COMMERCIAL_VERSION_BASE      2025.2
#define SO_COMMERCIAL_VERSION_STRING    "2025.2.1"
#define SO_COMMERCIAL_VERSION_BASE_STRING "2025.2"

/*
 * SO_INVENTOR_VERSION is the product version without dot.
 * For example SO_INVENTOR_VERSION is equal to 2023270 for first build of version 2023.2.7
 */

#define SO_INVENTOR_VERSION             2025210
#define TGS_VERSION                     SO_INVENTOR_VERSION

#ifndef SO_VERSION_DEPRECATED_ERROR
#define SO_VERSION_DEPRECATED_ERROR     0
#endif

/* x.x.x.x */
#define SO_VERSION_STRING               "10"
#define SO_VERSION_REVISION_STRING      "18"
#define SO_PATCH_STRING                 "1"
#define SO_BUILD_STRING                 "0"

/* "x.x" */
#define SO_COMPACT_VERSION_DOTTED_STRING SO_VERSION_STRING "." SO_VERSION_REVISION_STRING
/* "x.x.x.x" */
#define SO_FULL_VERSION_DOTTED_STRING    SO_COMPACT_VERSION_DOTTED_STRING "." SO_PATCH_STRING "." SO_BUILD_STRING

/* "xx" */
#define SO_COMPACT_VERSION_STRING        SO_VERSION_STRING "" SO_VERSION_REVISION_STRING
/* "xxxx" */
#define SO_FULL_VERSION_STRING           SO_COMPACT_VERSION_STRING "" SO_PATCH_STRING "" SO_BUILD_STRING

/* used in licensing : "x.x" */
#define SO_PRODUCT_VERSION_FOR_LICENSING SO_COMMERCIAL_VERSION_BASE_STRING

/* used in resources file */
#define SO_COMPANY_NAME     "Thermo Fisher Scientific"
#define SO_LEGAL_COPYRIGHT  " 1996-2025 FEI SAS"
#define SO_UNIX_LEGAL_COPYRIGHT  "@(#) Copyright (c) 1996-2025 FEI SAS"
#define SO_PRODUCT_VERSION  "10.18.1.0"
#define SO_FILE_VERSION     "101810"

#if defined(_DEBUG)
#define SO_FILE_VERSION_TAG     "D"
#else
#define SO_FILE_VERSION_TAG     ""
#endif

/* Used for internal string version notice (subject to changes)*/
#if defined(_WIN64) || defined(WIN64)
#define SO_PRODUCT_STRING_PLATFORM "64 bits"
#elif defined(_WIN32) || defined(WIN32)
#define SO_PRODUCT_STRING_PLATFORM "32 bits"
#elif defined(__hpux)
#if (__cplusplus >= 199707L)
#define SO_PRODUCT_STRING_PLATFORM "HP aCC"
#else
#define SO_PRODUCT_STRING_PLATFORM "HP C++"
#endif
#elif defined(__linux__)
#define SO_PRODUCT_STRING_PLATFORM "Linux"
#elif defined(__APPLE__)
#define SO_PRODUCT_STRING_PLATFORM "OSX"
#else
#define SO_PRODUCT_STRING_PLATFORM ""
#endif

#endif /* HIDDEN_FROM_DOC */

#endif /* _INVENTOR_VERSION_H_ */

