/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef _SOHEIGHTFIELDDETAIL_H
#define _SOHEIGHTFIELDDETAIL_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4251)
#endif

#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <Inventor/STL/vector>
#include <Inventor/details/SoSubDetail.h>
#include <Inventor/SbVec.h>

#include <LDM/SoLDMTileID.h>

class SoDataSet;
class SoAction;
class SoHeightFieldProperty;

/**
 * @VREXT Stores detail information about a picked cell in a heightfield.
 *
 * @ingroup VolumeVizDetails
 *
 * @DESCRIPTION
 *   A successful pick operation returns an SoPickedPoint object. If the picked
 *   geometry is an SoHeightFieldRender node, use the @B getDetail @b method and cast
 *   the result to this class to get extra information about the the pick.
 *
 *   SoHeightFieldDetail returns
 *     - The i,j,k position of the picked cell (position in data space).
 *     - The value of the picked cell retrieved from the current SoHeightFieldProperty
 *     - or the values of the picked cell when multiple SoHeightFieldProperty nodes are
 *       inherited.
 *     - The data set of the picked heightfield, i.e., the current SoHeightFieldProperty node.
 *     - or the data sets of the picked heightfield, when multiple SoHeightFieldProperty nodes are
 *       inherited.
 *
 * @SEE_ALSO
 *    SoDetail,
 *    SoHeightFieldProperty,
 *    SoHeightFieldGeometry,
 *    SoHeightFieldRender
 *
 * @DESCRIPTION
 *
 */
class VOLUMEVIZ_API SoHeightFieldDetail : public SoDetail
{

  SO_DETAIL_HEADER(SoHeightFieldDetail);

public:
  /**
  * Constructor.
  */
  SoHeightFieldDetail();
  /**
  * Destructor.
  */
  virtual ~SoHeightFieldDetail();

  /**
  * Returns the value of the picked cell in the specified property (SoHeightFieldProperty node).
  * @param propertyNumber is the number of the property to query.
  * @return value. Returns NaN if propertyNumber is not valid.
  *        Use the #getNumProperties method to get the number of properties.
  */
  double getValue(size_t propertyNumber) const;

  /**
   * Returns the number of active properties.
   */
  inline size_t getNumProperties() const { return m_properties.size(); }

  /**
  * Returns the specified property and its id.
  * @param propertyNumber is the number of the property to query.
  *        Use the #getNumProperties method to get the number of properties.
  * @param property is filled with a pointer to the queried property. NULL if propertyNumber is invalid.
  * @param id is filled with the id of the property. -1 if propertyNumber is invalid.
  * [OIVJAVA-WRAPPER PACK{PropertyInfo}]
  */
  void getProperty(size_t propertyNumber, SoHeightFieldProperty*& property, int& id) const;

  /**
  * Returns the position in data space (cell coordinates) of the picked cell.
  */
  const SbVec3i32& getIjkPos() const;

  /**
   * Get the height value of the nearest elevation point 
   */
  inline float getHeight() const { return m_height; }

  /**
   * Returns the color of the picked cell.
   */
  inline const SbVec4i32& getColor() const { return m_color; }

  /** @copydoc SoDetail::copy() */
  virtual SoDetail* copy() const;

SoINTERNAL public:
  static void   initClass();
  static void   exitClass();

  inline void setProperties(const SoLDM::DataSetIdPairList& propData) { m_properties = propData; }

  inline void setUvPos(const SbVec2f &pos) { m_uvPos = pos; }

  inline const SbVec2f& getUvPos() const { return m_uvPos; }

  inline void setIjkPos(const SbVec3i32 &pos) { m_ijkPos = pos; }

  inline void setTile(const SoLDMTileID& tile) { m_tileId = tile; }

  /** Return the tile correspoding to the intersection */
  inline const SoLDMTileID& getTile() const { return m_tileId; }

  /** Set elevation of picked point, as specified in SoHeightFieldGeometry. */
  inline void setHeight(float height) { m_height = height; }

  /** Specify color of picked point */
  inline void setColor(const SbVec4i32& color) { m_color = color; }

  /**
   * Fill m_values with values of properties at given position
   */
  void fetchValues(const SbVec3i32& pos);

private:
  SoLDM::DataSetIdPairList m_properties;
  std::vector<double> m_values;
  SbVec3i32 m_ijkPos;

  /** elevation of picked point, as specified in SoHeightFieldGeometry */
  float m_height;

  /** Color of picked point */
  SbVec4i32 m_color;

  SbVec2f m_uvPos;

  SoLDMTileID m_tileId;
};


#ifdef _WIN32
#pragma warning(pop)
#endif

#endif /* _SOHEIGHTFIELDDETAIL_H */


