/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.DUFOUR (Jun 2002)
**=======================================================================*/

#ifndef _SO_VOLUME_SKIN_DETAIL_
#define _SO_VOLUME_SKIN_DETAIL_

#include <Inventor/details/SoSubDetail.h>
#include <VolumeViz/details/SoVolumeDetail.h>


//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoVolumeSkinDetail
//
//  Detail about an SoVolumeSkin node.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * @VREXT Stores detail information about a picked voxel or pick ray in a data volume.
 * 
 * @ingroup VolumeVizDetails
 * 
 * @DESCRIPTION
 *   A successful pick operation returns an SoPickedPoint object. If the picked
 *   geometry is an SoVolumeSkin node, use the @B getDetail @b method and cast
 *   the result to this class to get extra information about the the pick.
 *   
 *   SoVolumeSkinDetail returns information about the first (closest)
 *   non-transparent voxel along the pick ray and/or information about all the voxels
 *   intersected by the pick ray (called a profile). For the first non-transparent
 *   voxel (if any) on the pick ray, it returns XYZ position, IJK location, and data
 *   value. For the profile defined by all the intersected voxels, it returns:
 *   
 *   - Profile position in object space (two XYZ points)
 *   
 *   - Profile location in the data volume (two IJK indices)
 *   
 *   - Number of values along the profile
 *   
 *   - Each voxel value and corresponding IJK location
 *
 * @B Limitations:@b
 *   - If multiple volumes are being combined under an SoMultiDataSeparator,
 *     the detail class only returns values for the first volume in the scene graph.
 * 
 * @SEE_ALSO
 *    SoDetail,
 *    SoVolumeDetail,
 *    SoVolumeSkin
 * 
 * 
 */
class VOLUMEVIZ_API SoVolumeSkinDetail : public SoVolumeDetail {

  SO_DETAIL_HEADER(SoVolumeSkinDetail);

 public:
  /**
   * Constructor.
   */
  SoVolumeSkinDetail();

  /**
   * Destructor.
   */
  virtual ~SoVolumeSkinDetail();

  /** @copydoc SoDetail::copy() */
  virtual SoDetail* copy() const;

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

private:

  /** Copy constructor */
  SoVolumeSkinDetail(const SoVolumeSkinDetail& detail);
  void operator=( const SoVolumeSkinDetail& base );	// not allowed.

};

#endif /* _SO_VOLUME_SKIN_DETAIL_ */


