/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef SO_UNIFORM_GRID_CLIPPING_ELEMENT
#define SO_UNIFORM_GRID_CLIPPING_ELEMENT

#include <Inventor/SbPList.h>
#include <Inventor/elements/SoAccumulatedElement.h>
#include <Inventor/STL/vector>

#ifdef _WIN32
#pragma warning( push )
#pragma warning(disable:4251)
#endif

class SoUniformGridClipping;

/**
 * @ingroup VolumeVizElements
 */
SoEXTENDER_Documented class VOLUMEVIZ_API SoUniformGridClippingElement : public SoAccumulatedElement {
  SO_ELEMENT_HEADER(SoUniformGridClippingElement) ;
  
 public:

  /** Sets the current texture unit. */
  static void set(SoState *state, SoNode *node) ;

  /** Overrides push() method to copy values from next instance in the stack. */
  virtual void push(SoState *state) ;
  
  /** Pop method. */
  virtual void pop(SoState *, const SoElement *prevTopElement) ;  

  /**
   * Returns all the grids.
   * [OIVJAVA-WRAPPER NAME{getAll}]
   */
  static const std::vector<SoUniformGridClipping *> *get(SoState *state);

  /**
   * Returns the first grid.
   */
  static void get(SoState *state, SoUniformGridClipping *&grid);

protected:

  /** Common Initialization. Directly called by the constructor. */
  virtual void commonInit();

  /** Initializes element. */
  virtual void init(SoState *state);

 SoINTERNAL public:
  
  // Initializes the SoUniformGridClippingElement class
  static void initClass() ;
  static void exitClass() ;

 protected:
  // Sets the element
  virtual void setElt(SoNode *node) ;
  
  virtual ~SoUniformGridClippingElement() ;

private:
  std::vector<SoUniformGridClipping *> m_grids;
  size_t m_startIndex;
} ;
/*----------------------------------------------------------------------------*/

#ifdef _WIN32
#pragma warning( pop )
#endif

#endif


