/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : B. GRANGE (Aug 2006)
**=======================================================================*/
  
#ifndef  _SO_VOLUME_CLIPPING_GROUP_ELEMENT_
#define  _SO_VOLUME_CLIPPING_GROUP_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>

class SoVolumeClippingGroup;

/**
 * @ingroup VolumeVizElements
 */
class VOLUMEVIZ_API SoVolumeClippingGroupElement : public SoReplacedElement {
  SO_ELEMENT_HEADER( SoVolumeClippingGroupElement );

public:

  /** @copydoc SoElement::push() */
  void push(SoState *state);

  /** @copydoc SoElement::pop() */
  void pop(SoState *state, const SoElement *prevTopElement);

  // Sets/Gets the current volume data attributes in the state
  static void set(SoState* state, SoNode *node, SoVolumeClippingGroup *ClippingGroupNode);
  static void get(SoState* state, SoVolumeClippingGroup *&ClippingGroupNode);

  // Default values
  static void getDefault(SoVolumeClippingGroup *&ClippingGroupNode);

protected:

  /** Initializes element */
  virtual void init(SoState* state);

  SoINTERNAL public:
  // Initializes the SoVolumeClippingGroupElement class
  static void initClass();
  static void exitClass();

protected:
  virtual void setElt( SoVolumeClippingGroup *ClippingGroupNode );

  virtual ~SoVolumeClippingGroupElement() ;


private:
  SoVolumeClippingGroup* m_ClippingGroupNode;
};

#endif // _SO_VOLUME_GROUP_ELEMENT_


